/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.mapper;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.Mapper;
import io.helidon.common.mapper.MapperException;
import io.helidon.common.mapper.MapperManager;
import io.helidon.common.mapper.spi.MapperProvider;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

final class MapperManagerImpl
implements MapperManager {
    private final List<MapperProvider> providers;
    private final Map<ClassCacheKey, Mapper<?, ?>> classCache = new ConcurrentHashMap();
    private final Map<GenericCacheKey, Mapper<?, ?>> typeCache = new ConcurrentHashMap();

    MapperManagerImpl(MapperManager.Builder builder) {
        this.providers = builder.mapperProviders();
    }

    @Override
    public <SOURCE, TARGET> TARGET map(SOURCE source, GenericType<SOURCE> sourceType, GenericType<TARGET> targetType) {
        try {
            return this.findMapper(sourceType, targetType, false).map(source);
        }
        catch (MapperException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.createMapperException(source, sourceType, targetType, e);
        }
    }

    @Override
    public <SOURCE, TARGET> TARGET map(SOURCE source, Class<SOURCE> sourceType, Class<TARGET> targetType) {
        try {
            return this.findMapper(sourceType, targetType, false).map(source);
        }
        catch (MapperException e) {
            throw e;
        }
        catch (Exception e) {
            throw this.createMapperException(source, GenericType.create(sourceType), GenericType.create(targetType), e);
        }
    }

    private RuntimeException createMapperException(Object source, GenericType<?> sourceType, GenericType<?> targetType, Throwable throwable) {
        throw new MapperException(GenericType.create(sourceType), GenericType.create(targetType), "Failed to map source of class '" + source.getClass().getName() + "'", throwable);
    }

    private <SOURCE, TARGET> Mapper<SOURCE, TARGET> findMapper(Class<SOURCE> sourceType, Class<TARGET> targetType, boolean fromTypes) {
        Mapper mapper = this.classCache.computeIfAbsent(new ClassCacheKey(sourceType, targetType), key -> this.fromProviders(sourceType, targetType).orElseGet(() -> {
            GenericType sourceGenericType = GenericType.create((Class)sourceType);
            GenericType targetGenericType = GenericType.create((Class)targetType);
            if (fromTypes) {
                return MapperManagerImpl.notFoundMapper(sourceGenericType, targetGenericType);
            }
            return this.findMapper(sourceGenericType, targetGenericType, true);
        }));
        return mapper;
    }

    private <SOURCE, TARGET> Mapper<SOURCE, TARGET> findMapper(GenericType<SOURCE> sourceType, GenericType<TARGET> targetType, boolean fromClasses) {
        Mapper mapper = this.typeCache.computeIfAbsent(new GenericCacheKey(sourceType, targetType), key -> this.fromProviders(sourceType, targetType).orElseGet(() -> {
            if (!fromClasses && sourceType.isClass() && targetType.isClass()) {
                return this.findMapper(sourceType.rawType(), targetType.rawType(), true);
            }
            return MapperManagerImpl.notFoundMapper(sourceType, targetType);
        }));
        return mapper;
    }

    private <SOURCE, TARGET> Optional<Mapper<?, ?>> fromProviders(Class<SOURCE> sourceType, Class<TARGET> targetType) {
        return this.providers.stream().flatMap(provider -> provider.mapper(sourceType, targetType).stream()).findFirst();
    }

    private <SOURCE, TARGET> Optional<Mapper<?, ?>> fromProviders(GenericType<SOURCE> sourceType, GenericType<TARGET> targetType) {
        return this.providers.stream().flatMap(provider -> provider.mapper(sourceType, targetType).stream()).findFirst();
    }

    private static <SOURCE, TARGET> Mapper<SOURCE, TARGET> notFoundMapper(GenericType<SOURCE> sourceType, GenericType<TARGET> targetType) {
        return source -> {
            throw new MapperException(sourceType, targetType, "Failed to find mapper.");
        };
    }

    private static final class ClassCacheKey {
        private final Class<?> sourceType;
        private final Class<?> targetType;

        private ClassCacheKey(Class<?> sourceType, Class<?> targetType) {
            this.sourceType = sourceType;
            this.targetType = targetType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof ClassCacheKey)) {
                return false;
            }
            ClassCacheKey that = (ClassCacheKey)o;
            return this.sourceType.equals(that.sourceType) && this.targetType.equals(that.targetType);
        }

        public int hashCode() {
            return Objects.hash(this.sourceType, this.targetType);
        }
    }

    private static final class GenericCacheKey {
        private final GenericType<?> sourceType;
        private final GenericType<?> targetType;

        private GenericCacheKey(GenericType<?> sourceType, GenericType<?> targetType) {
            this.sourceType = sourceType;
            this.targetType = targetType;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (!(o instanceof GenericCacheKey)) {
                return false;
            }
            GenericCacheKey that = (GenericCacheKey)o;
            return this.sourceType.equals(that.sourceType) && this.targetType.equals(that.targetType);
        }

        public int hashCode() {
            return Objects.hash(this.sourceType, this.targetType);
        }
    }
}

