/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.mapper.spi;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.Mapper;

@FunctionalInterface
public interface MapperProvider {
    public ProviderResponse mapper(Class<?> var1, Class<?> var2, String var3);

    default public ProviderResponse mapper(GenericType<?> sourceType, GenericType<?> targetType, String qualifier) {
        ProviderResponse resp;
        if (sourceType.isClass() && targetType.isClass() && (resp = this.mapper(sourceType.rawType(), targetType.rawType(), qualifier)).support() == Support.SUPPORTED) {
            return new ProviderResponse(Support.COMPATIBLE, resp.mapper());
        }
        return ProviderResponse.unsupported();
    }

    public record ProviderResponse(Support support, Mapper<?, ?> mapper) {
        private static final ProviderResponse UNSUPPORTED = new ProviderResponse(Support.UNSUPPORTED, null);

        public static ProviderResponse unsupported() {
            return UNSUPPORTED;
        }
    }

    public static enum Support {
        SUPPORTED,
        COMPATIBLE,
        UNSUPPORTED;

    }
}

