/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.mapper;

import io.helidon.common.Default;
import io.helidon.common.GenericType;
import io.helidon.common.mapper.DefaultsResolver;
import io.helidon.common.mapper.MapperException;
import io.helidon.common.mapper.Mappers;
import io.helidon.common.types.Annotation;
import io.helidon.common.types.Annotations;
import io.helidon.common.types.TypeName;
import io.helidon.service.registry.Service;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import java.util.function.Supplier;
import java.util.stream.Collectors;

@Service.Singleton
class DefaultResolverService
implements DefaultsResolver {
    private static final TypeName VALUE_TYPE = TypeName.create(Default.Value.class);
    private static final TypeName INT_TYPE = TypeName.create(Default.Int.class);
    private static final TypeName DOUBLE_TYPE = TypeName.create(Default.Double.class);
    private static final TypeName BOOLEAN_TYPE = TypeName.create(Default.Boolean.class);
    private static final TypeName LONG_TYPE = TypeName.create(Default.Long.class);
    private final Supplier<Mappers> mappers;

    @Service.Inject
    DefaultResolverService(Supplier<Mappers> mappers) {
        this.mappers = mappers;
    }

    @Override
    public List<?> resolve(Set<Annotation> annotations, GenericType<?> expectedType, String name) {
        Optional found = Annotations.findFirst((TypeName)VALUE_TYPE, annotations);
        if (found.isPresent()) {
            return this.value((Annotation)found.get(), expectedType, name);
        }
        found = Annotations.findFirst((TypeName)INT_TYPE, annotations);
        if (found.isPresent()) {
            return ((Annotation)found.get()).intValues().orElseGet(List::of);
        }
        found = Annotations.findFirst((TypeName)DOUBLE_TYPE, annotations);
        if (found.isPresent()) {
            return ((Annotation)found.get()).doubleValues().orElseGet(List::of);
        }
        found = Annotations.findFirst((TypeName)BOOLEAN_TYPE, annotations);
        if (found.isPresent()) {
            return ((Annotation)found.get()).booleanValues().orElseGet(List::of);
        }
        found = Annotations.findFirst((TypeName)LONG_TYPE, annotations);
        if (found.isPresent()) {
            return ((Annotation)found.get()).longValues().orElseGet(List::of);
        }
        return List.of();
    }

    private List<Object> value(Annotation annotation, GenericType<?> expectedType, String name) {
        List values = annotation.stringValues().orElseGet(List::of);
        try {
            return values.stream().map(it -> this.mappers.get().map(it, GenericType.STRING, expectedType, "defaults")).collect(Collectors.toUnmodifiableList());
        }
        catch (MapperException e) {
            throw new MapperException(GenericType.STRING, expectedType, "Default value mapping for: " + name, e);
        }
    }
}

