/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.metrics;

import io.helidon.common.metrics.InternalTagImpl;
import io.helidon.common.metrics.Loader;
import io.helidon.config.Config;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import org.eclipse.microprofile.metrics.Counter;
import org.eclipse.microprofile.metrics.Gauge;
import org.eclipse.microprofile.metrics.Histogram;
import org.eclipse.microprofile.metrics.Meter;
import org.eclipse.microprofile.metrics.Metric;
import org.eclipse.microprofile.metrics.MetricRegistry;
import org.eclipse.microprofile.metrics.MetricType;
import org.eclipse.microprofile.metrics.Timer;

public interface InternalBridge {
    public static final InternalBridge INSTANCE = Loader.internalBridge();

    public MetricID.Factory getMetricIDFactory();

    public Metadata.MetadataBuilder.Factory getMetadataBuilderFactory();

    public MetricRegistry.RegistryFactory getRegistryFactory();

    public static Metadata.MetadataBuilder newMetadataBuilder() {
        return INSTANCE.getMetadataBuilderFactory().newMetadataBuilder();
    }

    public MetricRegistry.RegistryFactory createRegistryFactory();

    public MetricRegistry.RegistryFactory createRegistryFactory(Config var1);

    public static interface Tag {
        public static Tag newTag(String name, String value) {
            return new InternalTagImpl(name, value);
        }

        public String getTagName();

        public String getTagValue();
    }

    public static interface Metadata {
        public String getName();

        public String getDisplayName();

        public Optional<String> getDescription();

        public String getType();

        public MetricType getTypeRaw();

        public Optional<String> getUnit();

        public boolean isReusable();

        public Map<String, String> getTags();

        public static Metadata newMetadata(String name, String displayName, String description, MetricType type, String unit, boolean isReusable, Map<String, String> tags) {
            MetadataBuilder builder = MetadataBuilder.Factory.INSTANCE.newMetadataBuilder().withName(name).withDescription(description).withDisplayName(displayName).withType(type).withTags(tags).withUnit(unit);
            return (isReusable ? builder.reusable() : builder.notReusable()).build();
        }

        public static Metadata newMetadata(String name, String displayName, String description, MetricType type, String unit, Map<String, String> tags) {
            return MetadataBuilder.Factory.INSTANCE.newMetadataBuilder().withName(name).withDescription(description).withDisplayName(displayName).withType(type).withTags(tags).withUnit(unit).build();
        }

        public static Metadata newMetadata(String name, String displayName, String description, MetricType type, String unit) {
            return MetadataBuilder.Factory.INSTANCE.newMetadataBuilder().withName(name).withDescription(description).withDisplayName(displayName).withType(type).withUnit(unit).build();
        }

        public static interface MetadataBuilder {
            public MetadataBuilder withName(String var1);

            public MetadataBuilder withDisplayName(String var1);

            public MetadataBuilder withDescription(String var1);

            public MetadataBuilder withType(MetricType var1);

            public MetadataBuilder withUnit(String var1);

            public MetadataBuilder reusable();

            public MetadataBuilder notReusable();

            public MetadataBuilder withTags(Map<String, String> var1);

            public Metadata build();

            public static interface Factory {
                public static final Factory INSTANCE = Loader.metadataBuilderFactory();

                public MetadataBuilder newMetadataBuilder();
            }
        }
    }

    public static interface MetricID
    extends Comparable<MetricID> {
        public String getName();

        public Map<String, String> getTags();

        default public List<Tag> getTagsAsList() {
            return this.getTags().entrySet().stream().map(entry -> Tag.newTag((String)entry.getKey(), (String)entry.getValue())).collect(Collectors.toList());
        }

        default public String getTagsAsString() {
            return this.getTags().entrySet().stream().map(entry -> String.format("%s=%s", entry.getKey(), entry.getValue())).collect(Collectors.joining(","));
        }

        @Override
        default public int compareTo(MetricID o) {
            int result = this.getName().compareTo(Objects.requireNonNull(o).getName());
            if (result != 0) {
                return result;
            }
            result = this.getTags().size() - o.getTags().size();
            if (result == 0) {
                Iterator<Map.Entry<String, String>> thisIterator = this.getTags().entrySet().iterator();
                Iterator<Map.Entry<String, String>> otherIterator = o.getTags().entrySet().iterator();
                while (thisIterator.hasNext() && otherIterator.hasNext()) {
                    Map.Entry<String, String> thisEntry = thisIterator.next();
                    Map.Entry<String, String> otherEntry = otherIterator.next();
                    result = thisEntry.getKey().compareTo(otherEntry.getKey());
                    if (result != 0) {
                        return result;
                    }
                    result = thisEntry.getValue().compareTo(otherEntry.getValue());
                    if (result == 0) continue;
                    return result;
                }
            }
            return result;
        }

        public static interface Factory {
            public static final Factory INSTANCE = Loader.metricIDFactory();

            public MetricID newMetricID(String var1);

            public MetricID newMetricID(String var1, Map<String, String> var2);
        }
    }

    public static interface MetricRegistry {
        public Counter counter(Metadata var1);

        public Counter counter(Metadata var1, Map<String, String> var2);

        public Counter counter(String var1);

        public Meter meter(Metadata var1);

        public Meter meter(Metadata var1, Map<String, String> var2);

        public Meter meter(String var1);

        public Histogram histogram(Metadata var1);

        public Histogram histogram(Metadata var1, Map<String, String> var2);

        public Histogram histogram(String var1);

        public Timer timer(Metadata var1);

        public Timer timer(Metadata var1, Map<String, String> var2);

        public Timer timer(String var1);

        public Map<MetricID, Metric> getBridgeMetrics();

        public Map<MetricID, Metric> getBridgeMetrics(Predicate<? super Map.Entry<? extends MetricID, ? extends Metric>> var1);

        public Optional<Map.Entry<? extends MetricID, ? extends Metric>> getBridgeMetric(String var1);

        public SortedSet<String> getNames();

        public SortedMap<MetricID, Counter> getBridgeCounters();

        public SortedMap<MetricID, Gauge> getBridgeGauges();

        public SortedMap<MetricID, Histogram> getBridgeHistograms();

        public SortedMap<MetricID, Meter> getBridgeMeters();

        public SortedMap<MetricID, Timer> getBridgeTimers();

        public <T extends Metric> T register(Metadata var1, T var2) throws IllegalArgumentException;

        public <T extends Metric> T register(MetricID var1, T var2) throws IllegalArgumentException;

        public boolean remove(String var1);

        public static interface RegistryFactory {
            public static final RegistryFactory INSTANCE = Loader.registryFactory();

            public MetricRegistry getBridgeRegistry(MetricRegistry.Type var1);
        }
    }
}

