/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.parameters;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.MapperManager;
import io.helidon.common.mapper.Mappers;
import io.helidon.common.mapper.OptionalValue;
import io.helidon.common.mapper.Value;
import io.helidon.common.parameters.ParametersEmpty;
import io.helidon.common.parameters.ParametersMap;
import io.helidon.common.parameters.ParametersSingleValueMap;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Supplier;

public interface Parameters {
    public static final GenericType<Parameters> GENERIC_TYPE = GenericType.create(Parameters.class);

    public static Builder builder(String component) {
        return new Builder(component);
    }

    public static Parameters empty(String component) {
        return new ParametersEmpty(component);
    }

    public static Parameters create(String component, Map<String, List<String>> params) {
        return new ParametersMap(ParametersEmpty.MAPPERS, component, params);
    }

    public static Parameters create(String component, Map<String, List<String>> params, String ... qualifiers) {
        return new ParametersMap(ParametersEmpty.MAPPERS, component, params, qualifiers);
    }

    public static Parameters createSingleValueMap(String component, Map<String, String> params) {
        return new ParametersSingleValueMap(ParametersEmpty.MAPPERS, component, params);
    }

    public List<String> all(String var1) throws NoSuchElementException;

    default public List<String> all(String name, Supplier<List<String>> defaultValues) {
        if (this.contains(name)) {
            return this.all(name);
        }
        return defaultValues.get();
    }

    public List<Value<String>> allValues(String var1) throws NoSuchElementException;

    default public List<Value<String>> allValues(String name, Supplier<List<Value<String>>> defaultValues) {
        if (this.contains(name)) {
            return this.allValues(name);
        }
        return defaultValues.get();
    }

    public String get(String var1) throws NoSuchElementException;

    public OptionalValue<String> first(String var1);

    public boolean contains(String var1);

    default public boolean isEmpty() {
        return this.size() == 0;
    }

    public int size();

    public Set<String> names();

    public String component();

    default public Map<String, List<String>> toMap() {
        HashMap<String, List<String>> result = new HashMap<String, List<String>>();
        for (String name : this.names()) {
            result.put(name, this.all(name));
        }
        return result;
    }

    public static class Builder
    implements io.helidon.common.Builder<Builder, Parameters> {
        private final Map<String, List<String>> params = new LinkedHashMap<String, List<String>>();
        private final String component;
        private Mappers mapperManager;

        private Builder(String component) {
            this.component = component;
        }

        public Parameters build() {
            if (this.mapperManager == null) {
                this.mapperManager = ParametersEmpty.MAPPERS;
            }
            return new ParametersMap(this.mapperManager, this.component, this.params);
        }

        public Builder mapperManager(MapperManager mapperManager) {
            this.mapperManager = mapperManager;
            return this;
        }

        public Builder add(String name, String ... values) {
            Objects.requireNonNull(name);
            this.params.computeIfAbsent(name, k -> new ArrayList()).addAll(Arrays.asList(values));
            return this;
        }

        public Builder set(String name, String ... values) {
            Objects.requireNonNull(name);
            this.params.put(name, new ArrayList<String>(List.of(values)));
            return this;
        }
    }
}

