/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Flow;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class SingleSubscriberHolder<T> {
    private final CompletableFuture<Flow.Subscriber<? super T>> subscriber = new CompletableFuture();
    private final AtomicBoolean closed = new AtomicBoolean(false);

    public boolean register(Flow.Subscriber<? super T> subscriber) {
        if (this.subscriber.complete(subscriber)) {
            return true;
        }
        Throwable error = null;
        try {
            this.subscriber.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            error = e;
        }
        catch (ExecutionException e) {
            error = e.getCause();
        }
        subscriber.onError(error != null ? error : new IllegalStateException("This publisher only supports a single subscriber!"));
        return false;
    }

    public void close(Consumer<Flow.Subscriber<? super T>> completionHandler) {
        if (!this.subscriber.completeExceptionally(new IllegalStateException("Publisher already closed.")) && this.closed.compareAndSet(false, true)) {
            try {
                Flow.Subscriber<? super T> s = this.subscriber.get();
                completionHandler.accept(s);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }

    public void cancel() {
        this.subscriber.completeExceptionally(new IllegalStateException("Canceled before any subscriber is registered!"));
        this.closed.set(true);
    }

    public Flow.Subscriber<? super T> get() throws InterruptedException, ExecutionException {
        return this.subscriber.get();
    }

    public boolean isClosed() {
        return this.closed.get();
    }
}

