/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive.valve;

import io.helidon.common.reactive.valve.Pausable;
import io.helidon.common.reactive.valve.Valve;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Function;

class ValveFilter<S, T>
implements Valve<S> {
    private final Valve<T> delegate;
    private final Function<BiConsumer<S, Pausable>, BiConsumer<T, Pausable>> filteringFunction;

    ValveFilter(Valve<T> delegate, Function<BiConsumer<S, Pausable>, BiConsumer<T, Pausable>> filteringFunction) {
        this.delegate = delegate;
        this.filteringFunction = filteringFunction;
    }

    @Override
    public void pause() {
        this.delegate.pause();
    }

    @Override
    public void resume() {
        this.delegate.resume();
    }

    @Override
    public void handle(BiConsumer<S, Pausable> onData, Consumer<Throwable> onError, Runnable onComplete) {
        this.delegate.handle(this.filteringFunction.apply(onData), onError, onComplete);
    }
}

