/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Flow;
import org.reactivestreams.Publisher;
import org.reactivestreams.Subscriber;
import org.reactivestreams.Subscription;
import reactor.core.CoreSubscriber;
import reactor.core.publisher.Flux;

@Deprecated
public final class ReactiveStreamsAdapter {
    private ReactiveStreamsAdapter() {
    }

    public static <T> Flow.Publisher<T> publisherToFlow(Publisher<T> publisher) {
        return new FlowPublisher(publisher);
    }

    public static <T> Flux<T> publisherFromFlow(Flow.Publisher<T> publisher) {
        return new ReactiveStreamsPublisher(publisher);
    }

    public static <T> Flow.Subscriber<T> subscriberToFlow(Subscriber<T> subscriber) {
        return new FlowSubscriber<T>(subscriber);
    }

    public static <T> Subscriber<T> subscriberFromFlow(Flow.Subscriber<T> subscriber) {
        return new ReactiveStreamsSubscriber<T>(subscriber);
    }

    private static class FlowSubscriber<T>
    implements Flow.Subscriber<T>,
    Subscription {
        private final Subscriber<? super T> s;
        private Flow.Subscription subscription;

        FlowSubscriber(Subscriber<? super T> s) {
            this.s = s;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            this.subscription = subscription;
            this.s.onSubscribe((Subscription)this);
        }

        @Override
        public void onNext(T o) {
            this.s.onNext(o);
        }

        @Override
        public void onError(Throwable throwable) {
            this.s.onError(throwable);
        }

        @Override
        public void onComplete() {
            this.s.onComplete();
        }

        public void request(long n) {
            this.subscription.request(n);
        }

        public void cancel() {
            this.subscription.cancel();
        }
    }

    private static class ReactiveStreamsSubscriber<T>
    implements CoreSubscriber<T>,
    Flow.Subscription {
        private final Flow.Subscriber<? super T> subscriber;
        private Subscription subscription;

        ReactiveStreamsSubscriber(Flow.Subscriber<? super T> subscriber) {
            this.subscriber = subscriber;
        }

        public void onSubscribe(Subscription s) {
            this.subscription = s;
            this.subscriber.onSubscribe(this);
        }

        public void onNext(T o) {
            this.subscriber.onNext(o);
        }

        public void onError(Throwable t) {
            this.subscriber.onError(t);
        }

        public void onComplete() {
            this.subscriber.onComplete();
        }

        @Override
        public void request(long n) {
            this.subscription.request(n);
        }

        @Override
        public void cancel() {
            this.subscription.cancel();
        }
    }

    private static class FlowPublisher<T>
    implements Flow.Publisher<T> {
        private final Publisher<T> pub;

        private FlowPublisher(Publisher<T> pub) {
            this.pub = pub;
        }

        @Override
        public void subscribe(Flow.Subscriber<? super T> subscriber) {
            this.pub.subscribe(new ReactiveStreamsSubscriber<T>(subscriber));
        }
    }

    private static class ReactiveStreamsPublisher<T>
    extends Flux<T> {
        private final Flow.Publisher<T> pub;

        private ReactiveStreamsPublisher(Flow.Publisher<T> pub) {
            this.pub = pub;
        }

        public void subscribe(CoreSubscriber<? super T> actual) {
            this.pub.subscribe(new FlowSubscriber<T>(actual));
        }
    }
}

