/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.CollectionsHelper;
import io.helidon.common.mapper.Mapper;
import io.helidon.common.reactive.Collector;
import io.helidon.common.reactive.FixedItemsPublisher;
import io.helidon.common.reactive.Flow;
import io.helidon.common.reactive.ListCollector;
import io.helidon.common.reactive.MultiCollectingProcessor;
import io.helidon.common.reactive.MultiEmpty;
import io.helidon.common.reactive.MultiError;
import io.helidon.common.reactive.MultiFirstProcessor;
import io.helidon.common.reactive.MultiFromPublisher;
import io.helidon.common.reactive.MultiMappingProcessor;
import io.helidon.common.reactive.MultiNever;
import io.helidon.common.reactive.Single;
import io.helidon.common.reactive.Subscribable;
import java.util.Collection;
import java.util.List;

public interface Multi<T>
extends Subscribable<T> {
    default public <U> Multi<U> map(Mapper<T, U> mapper) {
        MultiMappingProcessor<T, U> processor = new MultiMappingProcessor<T, U>(mapper);
        this.subscribe(processor);
        return processor;
    }

    default public Single<List<T>> collectList() {
        return this.collect(new ListCollector());
    }

    default public <U> Single<U> collect(Collector<T, U> collector) {
        MultiCollectingProcessor<T, U> processor = new MultiCollectingProcessor<T, U>(collector);
        this.subscribe(processor);
        return processor;
    }

    default public Single<T> first() {
        MultiFirstProcessor processor = new MultiFirstProcessor();
        this.subscribe(processor);
        return processor;
    }

    public static <T> Multi<T> from(Flow.Publisher<T> source) {
        if (source instanceof Multi) {
            return (Multi)source;
        }
        return new MultiFromPublisher<T>(source);
    }

    public static <T> Multi<T> just(Collection<T> items) {
        return new MultiFromPublisher<T>(new FixedItemsPublisher<T>(items));
    }

    @SafeVarargs
    public static <T> Multi<T> just(T ... items) {
        return new MultiFromPublisher(new FixedItemsPublisher(CollectionsHelper.listOf((Object[])items)));
    }

    public static <T> Multi<T> error(Throwable error) {
        return new MultiError(error);
    }

    public static <T> Multi<T> empty() {
        return MultiEmpty.instance();
    }

    public static <T> Multi<T> never() {
        return MultiNever.instance();
    }
}

