/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.BaseProcessor;
import io.helidon.common.reactive.Collector;
import io.helidon.common.reactive.Single;
import java.util.Objects;

final class MultiCollectingProcessor<T, U>
extends BaseProcessor<T, U>
implements Single<U> {
    private final Collector<T, U> collector;

    MultiCollectingProcessor(Collector<T, U> collector) {
        this.collector = Objects.requireNonNull(collector, "collector is null!");
    }

    @Override
    protected void hookOnNext(T item) {
        this.collector.collect(item);
    }

    @Override
    protected void hookOnComplete() {
        U value = this.collector.value();
        if (value == null) {
            this.onError(new IllegalStateException("Collector returned a null container"));
        } else {
            this.submit(value);
        }
    }
}

