/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import java.util.concurrent.atomic.AtomicLong;

public final class UnboundedSemaphore {
    private final AtomicLong atomicLong = new AtomicLong();

    private UnboundedSemaphore() {
    }

    long release(long n) {
        return this.atomicLong.updateAndGet(original -> {
            long r = original + n;
            if (r == Long.MAX_VALUE || ((original ^ r) & (n ^ r)) < 0L) {
                return Long.MAX_VALUE;
            }
            return original + n;
        });
    }

    public long tryAcquire() {
        return this.atomicLong.getAndUpdate(original -> {
            if (original == Long.MAX_VALUE) {
                return original;
            }
            if (original == 0L) {
                return 0L;
            }
            return original - 1L;
        });
    }

    long availablePermits() {
        return this.atomicLong.get();
    }

    public static UnboundedSemaphore create() {
        return new UnboundedSemaphore();
    }
}

