/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive.valve;

import io.helidon.common.reactive.Flow;
import io.helidon.common.reactive.valve.EmptyValve;
import io.helidon.common.reactive.valve.InputStreamValve;
import io.helidon.common.reactive.valve.IteratorValve;
import io.helidon.common.reactive.valve.PublisherValve;
import io.helidon.common.reactive.valve.Valve;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import java.util.concurrent.ExecutorService;

public class Valves {
    private static final Valve EMPTY = new EmptyValve();

    private Valves() {
    }

    @SafeVarargs
    public static <T> Valve<T> from(T ... t) {
        if (t == null || t.length == 0) {
            return Valves.empty();
        }
        return Valves.from(Arrays.asList(t));
    }

    public static <T> Valve<T> from(Iterable<T> iterable) {
        if (iterable == null) {
            return Valves.empty();
        }
        return new IteratorValve<T>(iterable.iterator());
    }

    public static Valve<ByteBuffer> from(InputStream stream, int bufferCapacity) {
        return Valves.from(stream, bufferCapacity, null);
    }

    public static Valve<ByteBuffer> from(InputStream stream, int bufferCapacity, ExecutorService executorService) {
        if (stream == null) {
            return Valves.empty();
        }
        if (executorService != null) {
            return new InputStreamValve.InputStreamExecutorValve(stream, bufferCapacity, executorService);
        }
        return new InputStreamValve(stream, bufferCapacity);
    }

    public static <T> Valve<T> from(Flow.Publisher<T> publisher) {
        if (publisher == null) {
            return Valves.empty();
        }
        return new PublisherValve<T>(publisher);
    }

    public static <T> Valve<T> empty() {
        return EMPTY;
    }
}

