/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive.valve;

import io.helidon.common.reactive.valve.RetryingPausableRegistry;
import io.helidon.common.reactive.valve.Valve;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.channels.Channels;
import java.nio.channels.WritableByteChannel;
import java.nio.charset.Charset;
import java.util.concurrent.ExecutorService;
import java.util.stream.Collector;
import java.util.stream.Collectors;

public class InputStreamValve
extends RetryingPausableRegistry<ByteBuffer>
implements Valve<ByteBuffer> {
    private final InputStream stream;
    private final int bufferSize;

    InputStreamValve(InputStream stream, int bufferSize) {
        this.stream = stream;
        this.bufferSize = bufferSize;
    }

    @Override
    protected ByteBuffer moreData() throws Throwable {
        byte[] bytes = new byte[this.bufferSize];
        int len = this.stream.read(bytes);
        return len != -1 ? ByteBuffer.wrap(bytes, 0, len) : null;
    }

    public static Collector<ByteBuffer, ByteArrayOutputStream, String> byteBufferStringCollector(Charset charset) {
        return Collectors.collectingAndThen(InputStreamValve.byteBufferByteArrayCollector(), bytes -> new String((byte[])bytes, charset));
    }

    public static Collector<ByteBuffer, ByteArrayOutputStream, ByteBuffer> byteBuffer2Collector() {
        return Collectors.collectingAndThen(InputStreamValve.byteBufferByteArrayCollector(), ByteBuffer::wrap);
    }

    public static Collector<ByteBuffer, ByteArrayOutputStream, byte[]> byteBufferByteArrayCollector() {
        return Collector.of(ByteArrayOutputStream::new, (stream, byteBuffer) -> {
            try {
                ByteArrayOutputStream byteArrayOutputStream = stream;
                synchronized (byteArrayOutputStream) {
                    WritableByteChannel channel = Channels.newChannel(stream);
                    channel.write((ByteBuffer)byteBuffer);
                }
            }
            catch (IOException e) {
                throw new IllegalStateException("This exception is never expected.", e);
            }
        }, (stream, stream2) -> {
            try {
                ByteArrayOutputStream byteArrayOutputStream = stream;
                synchronized (byteArrayOutputStream) {
                    stream2.writeTo((OutputStream)stream);
                }
                return stream;
            }
            catch (IOException e) {
                throw new IllegalStateException("This exception is never expected.", e);
            }
        }, ByteArrayOutputStream::toByteArray, new Collector.Characteristics[0]);
    }

    static class InputStreamExecutorValve
    extends InputStreamValve {
        private final ExecutorService executorService;

        InputStreamExecutorValve(InputStream stream, int bufferSize, ExecutorService executorService) {
            super(stream, bufferSize);
            this.executorService = executorService;
        }

        @Override
        protected void tryProcess() {
            this.executorService.submit(() -> super.tryProcess());
        }
    }
}

