/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive.valve;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.function.BinaryOperator;
import java.util.stream.Collector;

class UnorderedCollectorSupport<T, A, R> {
    private static final int CONCURRENCY_LIMIT = 256;
    private final Collector<T, A, R> collector;
    private final CompletableFuture<R> resultFuture = new CompletableFuture();
    private final ThreadLocal<A> intermediate = new ThreadLocal();
    private final List<A> intermediates = new ArrayList<A>(16);
    private A sharedIntermediate;

    UnorderedCollectorSupport(Collector<T, A, R> collector) {
        Objects.requireNonNull(collector, "Parameter 'collector' is null");
        if (!collector.characteristics().contains((Object)Collector.Characteristics.UNORDERED)) {
            throw new IllegalArgumentException("Collector parameter must have 'UNORDERED' characteristic.");
        }
        this.collector = collector;
    }

    CompletionStage<R> getResult() {
        return this.resultFuture;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void add(T item) {
        A a = this.intermediate.get();
        if (a == null) {
            List<A> list = this.intermediates;
            synchronized (list) {
                if (this.intermediates.size() >= 256) {
                    if (this.sharedIntermediate == null) {
                        this.sharedIntermediate = this.collector.supplier().get();
                        this.intermediates.add(this.sharedIntermediate);
                    }
                    this.collector.accumulator().accept(this.sharedIntermediate, item);
                    return;
                }
                a = this.collector.supplier().get();
                this.intermediate.set(a);
                this.intermediates.add(a);
            }
        }
        this.collector.accumulator().accept(a, item);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void complete() {
        List<A> list = this.intermediates;
        synchronized (list) {
            BinaryOperator<A> combiner = this.collector.combiner();
            Object a = this.intermediates.isEmpty() ? this.collector.supplier().get() : this.intermediates.get(0);
            for (int i = 1; i < this.intermediates.size(); ++i) {
                a = combiner.apply(a, this.intermediates.get(i));
            }
            if (this.collector.characteristics().contains((Object)Collector.Characteristics.IDENTITY_FINISH)) {
                this.resultFuture.complete(a);
            } else {
                this.resultFuture.complete(this.collector.finisher().apply(a));
            }
        }
    }

    void completeExceptionally(Throwable t) {
        this.resultFuture.completeExceptionally(t);
    }
}

