/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive.valve;

import io.helidon.common.reactive.valve.CloseableSupport;
import io.helidon.common.reactive.valve.Pausable;
import io.helidon.common.reactive.valve.PausableRegistry;
import io.helidon.common.reactive.valve.Valve;
import java.util.Collection;
import java.util.Iterator;
import java.util.Objects;
import java.util.Queue;
import java.util.Spliterator;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingDeque;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.Consumer;
import java.util.function.Predicate;

public class Tank<T>
implements Valve<T>,
BlockingQueue<T>,
AutoCloseable {
    private final int capacity;
    private final CloseableSupport closeableSupport = new CloseableSupport();
    private final Queue<Runnable> drainHandlers = new LinkedBlockingDeque<Runnable>();
    private final PausableRegistry<T> registry = new PausableRegistry<T>(){

        @Override
        protected void tryProcess() {
            Tank.this.tryProcess();
        }
    };
    private final ThreadLocal<Boolean> inDrainHandler = ThreadLocal.withInitial(() -> Boolean.FALSE);
    private final ArrayBlockingQueue<T> queue;

    public Tank(int capacity) {
        this.capacity = capacity;
        this.queue = new ArrayBlockingQueue(capacity, true);
    }

    public void whenDrain(Runnable drainHandler) {
        Objects.requireNonNull(drainHandler, "Parameter 'drainHandler' is null!");
        this.checkClosed();
        if (!this.inDrainHandler.get().booleanValue() && this.remainingCapacity() >= this.capacity / 2) {
            this.inDrainHandler.set(true);
            try {
                drainHandler.run();
            }
            finally {
                this.inDrainHandler.set(false);
            }
        } else {
            this.drainHandlers.add(drainHandler);
        }
    }

    @Override
    public void pause() {
        this.registry.pause();
    }

    @Override
    public void resume() {
        this.registry.resume();
    }

    @Override
    public void handle(BiConsumer<T, Pausable> onData, Consumer<Throwable> onError, Runnable onComplete) {
        this.registry.handle(onData, onError, onComplete);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void tryProcess() {
        if (this.registry.canProcess()) {
            boolean breakByPause = false;
            try {
                T t;
                BiConsumer<T, Pausable> onData = this.registry.getOnData();
                while ((t = this.poll()) != null) {
                    onData.accept(t, this);
                    if (!this.registry.paused()) continue;
                    breakByPause = true;
                    break;
                }
            }
            catch (Exception e) {
                this.registry.handleError(e);
            }
            finally {
                Runnable onComplete;
                if (!breakByPause && this.closeableSupport.closed() && (onComplete = this.registry.getOnComplete()) != null) {
                    onComplete.run();
                }
                this.registry.releaseProcessing();
            }
            this.processDrainHandlers();
        }
    }

    private void processDrainHandlers() {
        Runnable hndlr;
        while (!this.inDrainHandler.get().booleanValue() && !this.closeableSupport.closed() && this.remainingCapacity() >= this.capacity / 2 && (hndlr = this.drainHandlers.poll()) != null) {
            this.inDrainHandler.set(true);
            try {
                hndlr.run();
            }
            finally {
                this.inDrainHandler.set(false);
            }
        }
    }

    @Override
    public void close() {
        this.closeableSupport.close();
        this.tryProcess();
    }

    private void checkClosed() {
        if (this.closeableSupport.closed()) {
            throw new IllegalStateException("Tank instance is closed!");
        }
    }

    @Override
    public boolean add(T t) {
        this.checkClosed();
        boolean result = this.queue.add(t);
        this.tryProcess();
        return result;
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        this.checkClosed();
        boolean result = this.queue.addAll(c);
        this.tryProcess();
        return result;
    }

    @Override
    public boolean offer(T t) {
        if (this.closeableSupport.closed()) {
            return false;
        }
        boolean result = this.queue.offer(t);
        if (result) {
            this.tryProcess();
        }
        return result;
    }

    @Override
    public void put(T t) throws InterruptedException {
        this.checkClosed();
        this.queue.put(t);
        this.tryProcess();
    }

    @Override
    public boolean offer(T t, long timeout, TimeUnit unit) throws InterruptedException {
        if (this.closeableSupport.closed()) {
            return false;
        }
        boolean result = this.queue.offer(t, timeout, unit);
        if (result) {
            this.tryProcess();
        }
        return result;
    }

    @Override
    public void clear() {
        this.queue.clear();
    }

    @Override
    public T poll() {
        T t = this.queue.poll();
        if (t != null) {
            this.processDrainHandlers();
        }
        return t;
    }

    @Override
    public T take() throws InterruptedException {
        T t = this.queue.take();
        this.processDrainHandlers();
        return t;
    }

    @Override
    public T poll(long timeout, TimeUnit unit) throws InterruptedException {
        T t = this.queue.poll(timeout, unit);
        if (t != null) {
            this.processDrainHandlers();
        }
        return t;
    }

    @Override
    public boolean remove(Object o) {
        boolean result = this.queue.remove(o);
        if (result) {
            this.processDrainHandlers();
        }
        return result;
    }

    @Override
    public int drainTo(Collection<? super T> c) {
        int result = this.queue.drainTo(c);
        if (result > 0) {
            this.processDrainHandlers();
        }
        return result;
    }

    @Override
    public int drainTo(Collection<? super T> c, int maxElements) {
        int result = this.queue.drainTo(c, maxElements);
        if (result > 0) {
            this.processDrainHandlers();
        }
        return result;
    }

    @Override
    public boolean removeIf(Predicate<? super T> filter) {
        boolean result = this.queue.removeIf(filter);
        if (result) {
            this.processDrainHandlers();
        }
        return result;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean result = this.queue.removeAll(c);
        if (result) {
            this.processDrainHandlers();
        }
        return result;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean result = this.queue.retainAll(c);
        if (result) {
            this.processDrainHandlers();
        }
        return result;
    }

    @Override
    public T remove() {
        Object t = this.queue.remove();
        if (t != null) {
            this.processDrainHandlers();
        }
        return (T)t;
    }

    @Override
    public T element() {
        return (T)this.queue.element();
    }

    @Override
    public T peek() {
        return this.queue.peek();
    }

    @Override
    public int size() {
        return this.queue.size();
    }

    @Override
    public boolean isEmpty() {
        return this.queue.isEmpty();
    }

    @Override
    public int remainingCapacity() {
        return this.queue.remainingCapacity();
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        return false;
    }

    @Override
    public boolean contains(Object o) {
        return this.queue.contains(o);
    }

    @Override
    public Object[] toArray() {
        return this.queue.toArray();
    }

    @Override
    public <T1> T1[] toArray(T1[] a) {
        return this.queue.toArray(a);
    }

    @Override
    public Iterator<T> iterator() {
        return this.queue.iterator();
    }

    @Override
    public Spliterator<T> spliterator() {
        return this.queue.spliterator();
    }

    @Override
    public void forEach(Consumer<? super T> action) {
        this.queue.forEach((Consumer<T>)action);
    }
}

