/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;

class DeferredScalarSubscription<T>
extends AtomicInteger
implements Flow.Subscription {
    private final Flow.Subscriber<? super T> downstream;
    private T value;
    static final int NO_VALUE_NO_REQUEST = 0;
    static final int NO_VALUE_HAS_REQUEST = 1;
    static final int HAS_VALUE_NO_REQUEST = 2;
    static final int HAS_VALUE_HAS_REQUEST = 3;
    static final int COMPLETE = 4;
    static final int CANCELED = 5;

    DeferredScalarSubscription(Flow.Subscriber<? super T> downstream) {
        this.downstream = downstream;
    }

    @Override
    public void cancel() {
        if (this.getAndSet(5) != 5) {
            this.value = null;
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    @Override
    public final void request(long n) {
        if (n <= 0L) {
            if (this.getAndSet(5) == 5) return;
            this.downstream.onError(new IllegalArgumentException("Rule \u00a73.9 violated: non-positive requests are forbidden"));
            return;
        } else {
            while (true) {
                int state;
                if ((state = this.get()) == 2) {
                    T v = this.value;
                    this.value = null;
                    if (!this.compareAndSet(2, 3)) continue;
                    this.downstream.onNext(v);
                    if (!this.compareAndSet(3, 4)) return;
                    this.downstream.onComplete();
                    return;
                }
                if (state != 0 || this.compareAndSet(0, 1)) return;
            }
        }
    }

    public final void complete(T item) {
        while (true) {
            int state;
            if ((state = this.get()) == 1) {
                if (!this.compareAndSet(1, 3)) continue;
                this.downstream.onNext(item);
                if (!this.compareAndSet(3, 4)) break;
                this.downstream.onComplete();
                break;
            }
            if (state != 0) break;
            this.value = item;
            if (this.compareAndSet(0, 2)) break;
            this.value = null;
        }
    }

    protected final void subscribeSelf() {
        this.downstream.onSubscribe(this);
    }

    protected final Flow.Subscriber<? super T> downstream() {
        return this.downstream;
    }

    public final void complete() {
        int state;
        while ((state = this.get()) == 0 || state == 1) {
            if (!this.compareAndSet(state, 4)) continue;
            this.downstream.onComplete();
            return;
        }
    }

    public final void error(Throwable throwable) {
        int state;
        while ((state = this.get()) == 0 || state == 1) {
            if (!this.compareAndSet(state, 4)) continue;
            this.downstream.onError(throwable);
            return;
        }
    }

    private void writeObject(ObjectOutputStream stream) throws IOException {
        stream.defaultWriteObject();
    }

    private void readObject(ObjectInputStream stream) throws IOException, ClassNotFoundException {
        stream.defaultReadObject();
    }
}

