/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.concurrent.atomic.AtomicReferenceArray;

final class MultiObserveOn<T>
implements Multi<T> {
    private final Multi<T> source;
    private final Executor executor;
    private final int bufferSize;
    private final boolean delayError;

    MultiObserveOn(Multi<T> source, Executor executor, int bufferSize, boolean delayError) {
        this.source = source;
        this.executor = executor;
        this.bufferSize = bufferSize;
        this.delayError = delayError;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        this.source.subscribe(new ObserveOnSubscriber<T>(subscriber, this.executor, this.bufferSize, this.delayError));
    }

    static int roundToPowerOfTwo(int value) {
        return 1 << 32 - Integer.numberOfLeadingZeros(value - 1);
    }

    static final class ObserveOnSubscriber<T>
    extends AtomicInteger
    implements Flow.Subscriber<T>,
    Flow.Subscription,
    Runnable {
        private final Flow.Subscriber<? super T> downstream;
        private final Executor executor;
        private final int bufferSize;
        private final boolean delayError;
        private final AtomicLong requested;
        private final AtomicReferenceArray<T> queue;
        private final AtomicLong producerIndex;
        private final AtomicLong consumerIndex;
        private Flow.Subscription upstream;
        private Throwable error;
        private volatile boolean done;
        private volatile boolean canceled;
        private long emitted;
        private int consumed;

        ObserveOnSubscriber(Flow.Subscriber<? super T> downstream, Executor executor, int bufferSize, boolean delayError) {
            this.downstream = downstream;
            this.executor = executor;
            this.bufferSize = bufferSize;
            this.delayError = delayError;
            this.requested = new AtomicLong();
            this.queue = new AtomicReferenceArray(MultiObserveOn.roundToPowerOfTwo(bufferSize));
            this.producerIndex = new AtomicLong();
            this.consumerIndex = new AtomicLong();
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            this.upstream = subscription;
            this.downstream.onSubscribe(this);
            subscription.request(this.bufferSize);
        }

        @Override
        public void onNext(T item) {
            this.offer(item);
            this.schedule();
        }

        @Override
        public void onError(Throwable throwable) {
            this.error = throwable;
            this.done = true;
            this.schedule();
        }

        @Override
        public void onComplete() {
            this.done = true;
            this.schedule();
        }

        void schedule() {
            if (this.getAndIncrement() == 0) {
                this.executor.execute(this);
            }
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.onError(new IllegalArgumentException("Rule \u00a73.9 violated: non-positive requests are forbidden"));
            } else {
                SubscriptionHelper.addRequest(this.requested, n);
                this.schedule();
            }
        }

        @Override
        public void cancel() {
            this.canceled = true;
            this.upstream.cancel();
            this.schedule();
        }

        @Override
        public void run() {
            int missed = 1;
            long r = this.requested.get();
            Flow.Subscriber<T> downstream = this.downstream;
            int consumed = this.consumed;
            long emitted = this.emitted;
            int limit = this.bufferSize - (this.bufferSize >> 2);
            while (true) {
                if (this.canceled) {
                    this.clear();
                } else {
                    boolean empty;
                    Throwable ex;
                    boolean d = this.done;
                    if (d && !this.delayError && (ex = this.error) != null) {
                        this.canceled = true;
                        downstream.onError(ex);
                        continue;
                    }
                    if (r != emitted) {
                        T item = this.poll();
                        if (item != null) {
                            downstream.onNext(item);
                            ++emitted;
                            if (++consumed != limit) continue;
                            consumed = 0;
                            this.upstream.request(limit);
                            continue;
                        }
                        empty = true;
                    } else {
                        empty = this.isEmpty();
                    }
                    if (d && empty) {
                        this.canceled = true;
                        Throwable ex2 = this.error;
                        if (ex2 != null) {
                            downstream.onError(ex2);
                            continue;
                        }
                        downstream.onComplete();
                        continue;
                    }
                }
                this.emitted = emitted;
                this.consumed = consumed;
                missed = this.addAndGet(-missed);
                if (missed == 0) break;
                r = this.requested.get();
            }
        }

        void offer(T item) {
            AtomicReferenceArray<T> queue = this.queue;
            AtomicLong producerIndex = this.producerIndex;
            long pi = producerIndex.get();
            int mask = queue.length() - 1;
            int offset = (int)pi & mask;
            queue.lazySet(offset, item);
            producerIndex.lazySet(pi + 1L);
        }

        T poll() {
            int mask;
            AtomicReferenceArray<T> queue = this.queue;
            AtomicLong consumerIndex = this.consumerIndex;
            long ci = consumerIndex.get();
            int offset = (int)ci & (mask = queue.length() - 1);
            T item = queue.get(offset);
            if (item == null) {
                return null;
            }
            queue.lazySet(offset, null);
            consumerIndex.lazySet(ci + 1L);
            return item;
        }

        boolean isEmpty() {
            AtomicLong producerIndex = this.producerIndex;
            AtomicLong consumerIndex = this.consumerIndex;
            return producerIndex.get() == consumerIndex.get();
        }

        void clear() {
            while (this.poll() != null) {
            }
        }
    }
}

