/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.EmptySubscription;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.IntSupplier;

class MultiFromInputStream
implements Multi<ByteBuffer> {
    private final InputStream inputStream;
    private IntSupplier bufferSizeSupplier;

    MultiFromInputStream(InputStream inputStream, int bufferSize) {
        this.inputStream = inputStream;
        this.bufferSizeSupplier = () -> bufferSize;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber is null");
        try {
            this.inputStream.available();
        }
        catch (IOException e) {
            subscriber.onSubscribe(EmptySubscription.INSTANCE);
            subscriber.onError(e);
            return;
        }
        InputStreamSubscription subscription = new InputStreamSubscription(subscriber, this.inputStream, this.bufferSizeSupplier.getAsInt());
        subscriber.onSubscribe(subscription);
    }

    public Multi<ByteBuffer> withByteBufferSize(int bufferSize) {
        this.bufferSizeSupplier = () -> bufferSize;
        return this;
    }

    static class InputStreamSubscription
    extends AtomicLong
    implements Flow.Subscription {
        private final Flow.Subscriber<? super ByteBuffer> downstream;
        private final int bufferSize;
        private InputStream inputStream;
        private volatile int canceled;
        static final int NORMAL_CANCEL = 1;
        static final int BAD_REQUEST = 2;

        InputStreamSubscription(Flow.Subscriber<? super ByteBuffer> downstream, InputStream inputStream, int bufferSize) {
            this.downstream = downstream;
            this.inputStream = inputStream;
            this.bufferSize = bufferSize;
        }

        protected void submit(long n) {
            long emitted = 0L;
            Flow.Subscriber<? super ByteBuffer> downstream = this.downstream;
            while (true) {
                if (emitted != n) {
                    ByteBuffer value;
                    int isCanceled = this.canceled;
                    if (isCanceled != 0) {
                        this.inputStream = null;
                        if (isCanceled == 2) {
                            downstream.onError(new IllegalArgumentException("Rule \u00a73.9 violated: non-positive request amount is forbidden"));
                        }
                        return;
                    }
                    try {
                        value = ByteBuffer.wrap(this.inputStream.readNBytes(this.bufferSize));
                    }
                    catch (Throwable ex) {
                        this.inputStream = null;
                        this.canceled = 1;
                        downstream.onError(ex);
                        return;
                    }
                    if (value.limit() == 0) {
                        this.inputStream = null;
                        downstream.onComplete();
                        return;
                    }
                    downstream.onNext(value);
                    if (this.canceled != 0) continue;
                    ++emitted;
                    continue;
                }
                n = this.get();
                if (n != emitted) continue;
                n = SubscriptionHelper.produced(this, emitted);
                if (n == 0L) {
                    return;
                }
                emitted = 0L;
            }
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.canceled = 2;
                n = 1L;
            }
            if (SubscriptionHelper.addRequest(this, n) != 0L) {
                return;
            }
            this.trySubmit(n);
        }

        protected void trySubmit(long n) {
            this.submit(n);
        }

        @Override
        public void cancel() {
            this.canceled = 1;
            this.request(1L);
        }
    }
}

