/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.CompletionSingle;
import io.helidon.common.reactive.Single;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.Function;

final class SingleFlatMapSingle<T, R>
extends CompletionSingle<R> {
    private final Single<T> source;
    private final Function<? super T, ? extends Single<? extends R>> mapper;

    SingleFlatMapSingle(Single<T> source, Function<? super T, ? extends Single<? extends R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super R> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber is null");
        this.source.subscribe(new FlatMapSubscriber<T, R>(subscriber, this.mapper));
    }

    static final class FlatMapSubscriber<T, R>
    implements Flow.Subscriber<T>,
    Flow.Subscription {
        private final Flow.Subscriber<? super R> downstream;
        private final Function<? super T, ? extends Single<? extends R>> mapper;
        private final FlatMapNextSubscriber<R> nextSubscriber;
        private Flow.Subscription upstream;

        FlatMapSubscriber(Flow.Subscriber<? super R> downstream, Function<? super T, ? extends Single<? extends R>> mapper) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.nextSubscriber = new FlatMapNextSubscriber<R>(downstream);
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            Objects.requireNonNull(subscription, "subscription is null");
            if (this.upstream != null) {
                subscription.cancel();
                throw new IllegalStateException("Subscription already set!");
            }
            this.upstream = subscription;
            this.downstream.onSubscribe(this);
        }

        @Override
        public void onNext(T item) {
            Single<R> nextSource;
            try {
                nextSource = Objects.requireNonNull(this.mapper.apply(item), "The mapper returned a null Single");
            }
            catch (Throwable ex) {
                this.cancel();
                this.downstream.onError(ex);
                return;
            }
            this.upstream = this;
            nextSource.subscribe(this.nextSubscriber);
        }

        @Override
        public void onError(Throwable throwable) {
            if (this.upstream != this) {
                this.upstream = this;
                this.downstream.onError(throwable);
            }
        }

        @Override
        public void onComplete() {
            if (this.upstream != this) {
                this.upstream = this;
                this.downstream.onComplete();
            }
        }

        @Override
        public void request(long n) {
            Flow.Subscription s = this.upstream;
            if (s != this) {
                s.request(n);
            }
        }

        @Override
        public void cancel() {
            Flow.Subscription s = this.upstream;
            if (s != this) {
                this.upstream = this;
                s.cancel();
            }
            this.nextSubscriber.cancel();
        }

        static final class FlatMapNextSubscriber<R>
        extends AtomicReference<Flow.Subscription>
        implements Flow.Subscriber<R>,
        Flow.Subscription {
            private final Flow.Subscriber<? super R> downstream;

            FlatMapNextSubscriber(Flow.Subscriber<? super R> downstream) {
                this.downstream = downstream;
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                Objects.requireNonNull(subscription, "subscription is null");
                if (this.compareAndSet(null, subscription)) {
                    subscription.request(1L);
                } else if (this.get() != null) {
                    subscription.cancel();
                    if (this.get() != this) {
                        throw new IllegalStateException("Subscription already set");
                    }
                }
            }

            @Override
            public void onNext(R item) {
                this.downstream.onNext(item);
            }

            @Override
            public void onError(Throwable throwable) {
                this.downstream.onError(throwable);
            }

            @Override
            public void onComplete() {
                this.downstream.onComplete();
            }

            @Override
            public void request(long n) {
            }

            @Override
            public void cancel() {
                Flow.Subscription s = this.getAndSet(this);
                if (s != null && s != this) {
                    s.cancel();
                }
            }
        }
    }
}

