/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Awaitable;
import io.helidon.common.reactive.CompletionAwaitable;
import io.helidon.common.reactive.FunctionalSubscriber;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.MultiOnCompleteResumeWith;
import io.helidon.common.reactive.MultiOnErrorResumeWith;
import io.helidon.common.reactive.SingleDefaultIfEmpty;
import io.helidon.common.reactive.SingleDefer;
import io.helidon.common.reactive.SingleEmpty;
import io.helidon.common.reactive.SingleError;
import io.helidon.common.reactive.SingleFlatMapIterable;
import io.helidon.common.reactive.SingleFlatMapMulti;
import io.helidon.common.reactive.SingleFlatMapSingle;
import io.helidon.common.reactive.SingleFromCompletionStage;
import io.helidon.common.reactive.SingleFromPublisher;
import io.helidon.common.reactive.SingleJust;
import io.helidon.common.reactive.SingleMapperPublisher;
import io.helidon.common.reactive.SingleNever;
import io.helidon.common.reactive.SingleObserveOn;
import io.helidon.common.reactive.SingleOnErrorResume;
import io.helidon.common.reactive.SingleOnErrorResumeWith;
import io.helidon.common.reactive.SingleRetry;
import io.helidon.common.reactive.SingleSwitchIfEmpty;
import io.helidon.common.reactive.SingleTakeUntilPublisher;
import io.helidon.common.reactive.SingleTappedPublisher;
import io.helidon.common.reactive.SingleTimeout;
import io.helidon.common.reactive.SingleTimer;
import io.helidon.common.reactive.SingleToFuture;
import io.helidon.common.reactive.SingleToOptionalFuture;
import io.helidon.common.reactive.Subscribable;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Supplier;

public interface Single<T>
extends Subscribable<T>,
CompletionStage<T>,
Awaitable<T> {
    public static <T> Single<T> defer(Supplier<? extends Single<? extends T>> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return new SingleDefer(supplier);
    }

    public static <T> Single<T> empty() {
        return SingleEmpty.instance();
    }

    public static <T> Single<T> error(Throwable error) {
        return new SingleError(error);
    }

    @Deprecated
    public static <T> Single<T> from(CompletionStage<T> completionStage) {
        return Single.create(completionStage, false);
    }

    @Deprecated
    public static <T> Single<T> from(CompletionStage<T> completionStage, boolean nullMeansEmpty) {
        Objects.requireNonNull(completionStage, "completionStage is null");
        return new SingleFromCompletionStage<T>(completionStage, nullMeansEmpty);
    }

    @Deprecated
    public static <T> Single<T> from(Flow.Publisher<T> source) {
        Objects.requireNonNull(source, "source is null!");
        if (source instanceof Single) {
            return (Single)source;
        }
        return new SingleFromPublisher<T>(source);
    }

    @Deprecated
    public static <T> Single<T> from(Single<T> single) {
        return Single.create(single);
    }

    public static <T> Single<T> create(CompletionStage<T> completionStage) {
        return Single.create(completionStage, false);
    }

    public static <T> Single<T> create(CompletionStage<T> completionStage, boolean nullMeansEmpty) {
        Objects.requireNonNull(completionStage, "completionStage is null");
        return new SingleFromCompletionStage<T>(completionStage, nullMeansEmpty);
    }

    public static <T> Single<T> create(Flow.Publisher<T> source) {
        Objects.requireNonNull(source, "source is null!");
        if (source instanceof Single) {
            return (Single)source;
        }
        return new SingleFromPublisher<T>(source);
    }

    public static <T> Single<T> create(Single<T> single) {
        return Single.create(single);
    }

    public static <T> Single<T> just(T item) {
        return new SingleJust<T>(item);
    }

    public static <T> Single<T> never() {
        return new SingleNever();
    }

    public static Single<Long> timer(long time, TimeUnit unit, ScheduledExecutorService executor) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(executor, "executor is null");
        return new SingleTimer(time, unit, executor);
    }

    default public <U> U to(Function<? super Single<T>, ? extends U> converter) {
        return converter.apply(this);
    }

    default public <U> Single<U> compose(Function<? super Single<T>, ? extends Single<? extends U>> composer) {
        return this.to(composer);
    }

    @Override
    default public Single<T> defaultIfEmpty(T defaultItem) {
        Objects.requireNonNull(defaultItem, "defaultItem is null");
        return new SingleDefaultIfEmpty<T>(this, defaultItem);
    }

    @Override
    default public <U> Multi<U> flatMap(Function<? super T, ? extends Flow.Publisher<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return new SingleFlatMapMulti(this, mapper);
    }

    @Override
    default public <U> Multi<U> flatMapIterable(Function<? super T, ? extends Iterable<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return new SingleFlatMapIterable(this, mapper);
    }

    default public <U> Single<U> flatMapSingle(Function<? super T, ? extends Single<? extends U>> mapper) {
        return new SingleFlatMapSingle(this, mapper);
    }

    @Override
    default public <U> Single<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return new SingleMapperPublisher<T, U>(this, mapper);
    }

    @Override
    default public Single<T> observeOn(Executor executor) {
        Objects.requireNonNull(executor, "executor is null");
        return new SingleObserveOn(this, executor);
    }

    @Override
    default public Single<T> onCancel(Runnable onCancel) {
        return new SingleTappedPublisher(this, null, null, null, null, null, onCancel);
    }

    @Override
    default public Single<T> onComplete(Runnable onComplete) {
        return new SingleTappedPublisher(this, null, null, null, onComplete, null, null);
    }

    @Override
    default public Single<T> onError(Consumer<? super Throwable> onErrorConsumer) {
        return new SingleTappedPublisher(this, null, null, onErrorConsumer, null, null, null);
    }

    @Override
    default public Single<T> onErrorResume(Function<? super Throwable, ? extends T> onError) {
        return new SingleOnErrorResume<T>(this, onError);
    }

    default public Single<T> onErrorResumeWithSingle(Function<? super Throwable, ? extends Single<? extends T>> onError) {
        return new SingleOnErrorResumeWith(this, onError);
    }

    @Override
    default public Multi<T> onErrorResumeWith(Function<? super Throwable, ? extends Flow.Publisher<? extends T>> onError) {
        return new MultiOnErrorResumeWith(Multi.create(this), onError);
    }

    @Override
    default public Multi<T> onCompleteResume(T item) {
        Objects.requireNonNull(item, "item is null");
        return this.onCompleteResumeWith(Multi.singleton(item));
    }

    @Override
    default public Multi<T> onCompleteResumeWith(Flow.Publisher<? extends T> publisher) {
        return new MultiOnCompleteResumeWith<T>(Multi.create(this), publisher);
    }

    @Override
    default public Single<T> onTerminate(Runnable onTerminate) {
        return new SingleTappedPublisher(this, null, null, e -> onTerminate.run(), onTerminate, null, onTerminate);
    }

    @Override
    default public Single<T> peek(Consumer<? super T> consumer) {
        return new SingleTappedPublisher<T>(this, null, consumer, null, null, null, null);
    }

    @Override
    default public Single<T> retry(long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("count >= 0L required");
        }
        return new SingleRetry(this, count);
    }

    @Override
    default public Single<T> retry(BiPredicate<? super Throwable, ? super Long> predicate) {
        Objects.requireNonNull(predicate, "whenFunction is null");
        return new SingleRetry(this, predicate);
    }

    @Override
    default public <U> Single<T> retryWhen(BiFunction<? super Throwable, ? super Long, ? extends Flow.Publisher<U>> whenFunction) {
        Objects.requireNonNull(whenFunction, "whenFunction is null");
        return new SingleRetry(this, whenFunction);
    }

    default public Single<T> switchIfEmpty(Single<T> other) {
        Objects.requireNonNull(other, "other is null");
        return new SingleSwitchIfEmpty<T>(this, other);
    }

    @Override
    default public <U> Single<T> takeUntil(Flow.Publisher<U> other) {
        Objects.requireNonNull(other, "other is null");
        return new SingleTakeUntilPublisher(this, other);
    }

    @Override
    default public Single<T> timeout(long timeout, TimeUnit unit, ScheduledExecutorService executor) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(executor, "executor is null");
        return new SingleTimeout(this, timeout, unit, executor, null);
    }

    default public Single<T> timeout(long timeout, TimeUnit unit, ScheduledExecutorService executor, Single<T> fallback) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(fallback, "fallback is null");
        return new SingleTimeout<T>(this, timeout, unit, executor, fallback);
    }

    default public T get() throws InterruptedException, ExecutionException {
        return this.toStage().toCompletableFuture().get();
    }

    default public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        return this.toStage().toCompletableFuture().get(timeout, unit);
    }

    default public Single<Optional<T>> toOptionalSingle() {
        try {
            SingleToOptionalFuture subscriber = new SingleToOptionalFuture();
            this.subscribe(subscriber);
            return Single.create(subscriber);
        }
        catch (Throwable ex) {
            return Single.error(ex);
        }
    }

    default public CompletionStage<T> toStage() {
        return this.toStage(false);
    }

    default public CompletionStage<T> toStage(boolean completeWithoutValue) {
        try {
            SingleToFuture subscriber = new SingleToFuture(this, completeWithoutValue);
            this.subscribe(subscriber);
            return subscriber;
        }
        catch (Throwable ex) {
            CompletableFuture future = new CompletableFuture();
            future.completeExceptionally(ex);
            return future;
        }
    }

    default public CompletionAwaitable<Void> forSingle(Consumer<T> consumer) {
        return this.thenAccept(consumer);
    }

    default public CompletionAwaitable<Void> ignoreElement() {
        return this.forSingle(t -> {});
    }

    default public Single<T> cancel() {
        CompletableFuture future = new CompletableFuture();
        FunctionalSubscriber<Object> subscriber = new FunctionalSubscriber<Object>(future::complete, future::completeExceptionally, () -> future.complete(null), Flow.Subscription::cancel);
        this.subscribe(subscriber);
        return Single.create(future);
    }

    @Override
    public <U> CompletionAwaitable<U> thenApply(Function<? super T, ? extends U> var1);

    @Override
    public <U> CompletionAwaitable<U> thenApplyAsync(Function<? super T, ? extends U> var1);

    @Override
    public <U> CompletionAwaitable<U> thenApplyAsync(Function<? super T, ? extends U> var1, Executor var2);

    public CompletionAwaitable<Void> thenAccept(Consumer<? super T> var1);

    public CompletionAwaitable<Void> thenAcceptAsync(Consumer<? super T> var1);

    public CompletionAwaitable<Void> thenAcceptAsync(Consumer<? super T> var1, Executor var2);

    public CompletionAwaitable<Void> thenRun(Runnable var1);

    public CompletionAwaitable<Void> thenRunAsync(Runnable var1);

    public CompletionAwaitable<Void> thenRunAsync(Runnable var1, Executor var2);

    @Override
    public <U, V> CompletionAwaitable<V> thenCombine(CompletionStage<? extends U> var1, BiFunction<? super T, ? super U, ? extends V> var2);

    @Override
    public <U, V> CompletionAwaitable<V> thenCombineAsync(CompletionStage<? extends U> var1, BiFunction<? super T, ? super U, ? extends V> var2);

    @Override
    public <U, V> CompletionAwaitable<V> thenCombineAsync(CompletionStage<? extends U> var1, BiFunction<? super T, ? super U, ? extends V> var2, Executor var3);

    public <U> CompletionAwaitable<Void> thenAcceptBoth(CompletionStage<? extends U> var1, BiConsumer<? super T, ? super U> var2);

    public <U> CompletionAwaitable<Void> thenAcceptBothAsync(CompletionStage<? extends U> var1, BiConsumer<? super T, ? super U> var2);

    public <U> CompletionAwaitable<Void> thenAcceptBothAsync(CompletionStage<? extends U> var1, BiConsumer<? super T, ? super U> var2, Executor var3);

    public CompletionAwaitable<Void> runAfterBoth(CompletionStage<?> var1, Runnable var2);

    public CompletionAwaitable<Void> runAfterBothAsync(CompletionStage<?> var1, Runnable var2);

    public CompletionAwaitable<Void> runAfterBothAsync(CompletionStage<?> var1, Runnable var2, Executor var3);

    @Override
    public <U> CompletionAwaitable<U> applyToEither(CompletionStage<? extends T> var1, Function<? super T, U> var2);

    @Override
    public <U> CompletionAwaitable<U> applyToEitherAsync(CompletionStage<? extends T> var1, Function<? super T, U> var2);

    @Override
    public <U> CompletionAwaitable<U> applyToEitherAsync(CompletionStage<? extends T> var1, Function<? super T, U> var2, Executor var3);

    public CompletionAwaitable<Void> acceptEither(CompletionStage<? extends T> var1, Consumer<? super T> var2);

    public CompletionAwaitable<Void> acceptEitherAsync(CompletionStage<? extends T> var1, Consumer<? super T> var2);

    public CompletionAwaitable<Void> acceptEitherAsync(CompletionStage<? extends T> var1, Consumer<? super T> var2, Executor var3);

    public CompletionAwaitable<Void> runAfterEither(CompletionStage<?> var1, Runnable var2);

    public CompletionAwaitable<Void> runAfterEitherAsync(CompletionStage<?> var1, Runnable var2);

    public CompletionAwaitable<Void> runAfterEitherAsync(CompletionStage<?> var1, Runnable var2, Executor var3);

    @Override
    public <U> CompletionAwaitable<U> thenCompose(Function<? super T, ? extends CompletionStage<U>> var1);

    @Override
    public <U> CompletionAwaitable<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> var1);

    @Override
    public <U> CompletionAwaitable<U> thenComposeAsync(Function<? super T, ? extends CompletionStage<U>> var1, Executor var2);

    @Override
    public <U> CompletionAwaitable<U> handle(BiFunction<? super T, Throwable, ? extends U> var1);

    @Override
    public <U> CompletionAwaitable<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> var1);

    @Override
    public <U> CompletionAwaitable<U> handleAsync(BiFunction<? super T, Throwable, ? extends U> var1, Executor var2);

    @Override
    public CompletionAwaitable<T> whenComplete(BiConsumer<? super T, ? super Throwable> var1);

    @Override
    public CompletionAwaitable<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> var1);

    @Override
    public CompletionAwaitable<T> whenCompleteAsync(BiConsumer<? super T, ? super Throwable> var1, Executor var2);

    @Override
    public CompletionAwaitable<T> exceptionally(Function<Throwable, ? extends T> var1);

    public CompletionAwaitable<T> exceptionallyAccept(Consumer<Throwable> var1);
}

