/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.FunctionalSubscriber;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;

public interface Subscribable<T>
extends Flow.Publisher<T> {
    @Override
    default public void subscribe(Consumer<? super T> consumer) {
        this.subscribe(new FunctionalSubscriber<T>(consumer, null, null, null));
    }

    default public void subscribe(Consumer<? super T> consumer, Consumer<? super Throwable> errorConsumer) {
        this.subscribe(new FunctionalSubscriber<T>(consumer, errorConsumer, null, null));
    }

    default public void subscribe(Consumer<? super T> consumer, Consumer<? super Throwable> errorConsumer, Runnable completeConsumer) {
        this.subscribe(new FunctionalSubscriber<T>(consumer, errorConsumer, completeConsumer, null));
    }

    default public void subscribe(Consumer<? super T> consumer, Consumer<? super Throwable> errorConsumer, Runnable completeConsumer, Consumer<? super Flow.Subscription> subscriptionConsumer) {
        this.subscribe(new FunctionalSubscriber<T>(consumer, errorConsumer, completeConsumer, subscriptionConsumer));
    }

    public Subscribable<T> defaultIfEmpty(T var1);

    public <U> Subscribable<U> flatMap(Function<? super T, ? extends Flow.Publisher<? extends U>> var1);

    public <U> Subscribable<U> flatMapIterable(Function<? super T, ? extends Iterable<? extends U>> var1);

    public <U> Subscribable<U> map(Function<? super T, ? extends U> var1);

    public Subscribable<T> observeOn(Executor var1);

    public Subscribable<T> onCancel(Runnable var1);

    public Subscribable<T> onComplete(Runnable var1);

    public Subscribable<T> onError(Consumer<? super Throwable> var1);

    public Subscribable<T> onErrorResumeWith(Function<? super Throwable, ? extends Flow.Publisher<? extends T>> var1);

    public Subscribable<T> onErrorResume(Function<? super Throwable, ? extends T> var1);

    public Subscribable<T> onCompleteResume(T var1);

    public Subscribable<T> onCompleteResumeWith(Flow.Publisher<? extends T> var1);

    public Subscribable<T> onTerminate(Runnable var1);

    public Subscribable<T> peek(Consumer<? super T> var1);

    public Subscribable<T> retry(long var1);

    public Subscribable<T> retry(BiPredicate<? super Throwable, ? super Long> var1);

    public <U> Subscribable<T> retryWhen(BiFunction<? super Throwable, ? super Long, ? extends Flow.Publisher<U>> var1);

    public <U> Subscribable<T> takeUntil(Flow.Publisher<U> var1);

    public Subscribable<T> timeout(long var1, TimeUnit var3, ScheduledExecutorService var4);
}

