/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Collector;
import io.helidon.common.reactive.ConcatPublisher;
import io.helidon.common.reactive.FunctionalSubscriber;
import io.helidon.common.reactive.LoggingPublisher;
import io.helidon.common.reactive.MultiCollectPublisher;
import io.helidon.common.reactive.MultiCollectorPublisher;
import io.helidon.common.reactive.MultiConcatArray;
import io.helidon.common.reactive.MultiDefaultIfEmpty;
import io.helidon.common.reactive.MultiDefer;
import io.helidon.common.reactive.MultiDeferredDefaultIfEmpty;
import io.helidon.common.reactive.MultiDistinctPublisher;
import io.helidon.common.reactive.MultiDropWhilePublisher;
import io.helidon.common.reactive.MultiEmpty;
import io.helidon.common.reactive.MultiError;
import io.helidon.common.reactive.MultiFilterPublisher;
import io.helidon.common.reactive.MultiFirstPublisher;
import io.helidon.common.reactive.MultiFlatMapIterable;
import io.helidon.common.reactive.MultiFlatMapPublisher;
import io.helidon.common.reactive.MultiFromArrayPublisher;
import io.helidon.common.reactive.MultiFromCompletionStage;
import io.helidon.common.reactive.MultiFromIterable;
import io.helidon.common.reactive.MultiFromPublisher;
import io.helidon.common.reactive.MultiFromStream;
import io.helidon.common.reactive.MultiIfEmptyPublisher;
import io.helidon.common.reactive.MultiInterval;
import io.helidon.common.reactive.MultiJustPublisher;
import io.helidon.common.reactive.MultiLimitPublisher;
import io.helidon.common.reactive.MultiMapperPublisher;
import io.helidon.common.reactive.MultiNever;
import io.helidon.common.reactive.MultiObserveOn;
import io.helidon.common.reactive.MultiOnCompleteResumeWith;
import io.helidon.common.reactive.MultiOnErrorResumeWith;
import io.helidon.common.reactive.MultiRangeLongPublisher;
import io.helidon.common.reactive.MultiRangePublisher;
import io.helidon.common.reactive.MultiReduce;
import io.helidon.common.reactive.MultiReduceFull;
import io.helidon.common.reactive.MultiRetry;
import io.helidon.common.reactive.MultiSkipPublisher;
import io.helidon.common.reactive.MultiSwitchIfEmpty;
import io.helidon.common.reactive.MultiTakeUntilPublisher;
import io.helidon.common.reactive.MultiTakeWhilePublisher;
import io.helidon.common.reactive.MultiTappedPublisher;
import io.helidon.common.reactive.MultiTimeout;
import io.helidon.common.reactive.MultiTimer;
import io.helidon.common.reactive.Single;
import io.helidon.common.reactive.Subscribable;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Executor;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import java.util.function.BiPredicate;
import java.util.function.Consumer;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.function.Supplier;
import java.util.logging.Level;
import java.util.stream.Stream;

public interface Multi<T>
extends Subscribable<T> {
    public static <T> Multi<T> concat(Flow.Publisher<T> firstMulti, Flow.Publisher<T> secondMulti) {
        return ConcatPublisher.create(firstMulti, secondMulti);
    }

    @SafeVarargs
    public static <T> Multi<T> concat(Flow.Publisher<T> firstPublisher, Flow.Publisher<T> secondPublisher, Flow.Publisher<T> ... morePublishers) {
        Flow.Publisher[] prefixed = new Flow.Publisher[2 + morePublishers.length];
        prefixed[0] = firstPublisher;
        prefixed[1] = secondPublisher;
        System.arraycopy(morePublishers, 0, prefixed, 2, morePublishers.length);
        return Multi.concatArray(prefixed);
    }

    @SafeVarargs
    public static <T> Multi<T> concatArray(Flow.Publisher<T> ... publishers) {
        if (publishers.length == 0) {
            return Multi.empty();
        }
        if (publishers.length == 1) {
            return Multi.create(publishers[0]);
        }
        return new MultiConcatArray<T>(publishers);
    }

    public static <T> Multi<T> defer(Supplier<? extends Flow.Publisher<? extends T>> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return new MultiDefer(supplier);
    }

    public static <T> Multi<T> empty() {
        return MultiEmpty.instance();
    }

    public static <T> Multi<T> error(Throwable error) {
        return MultiError.create(error);
    }

    @Deprecated
    public static <T> Multi<T> from(CompletionStage<T> completionStage) {
        return Multi.create(completionStage);
    }

    @Deprecated
    public static <T> Multi<T> from(CompletionStage<T> completionStage, boolean nullMeansEmpty) {
        return Multi.create(completionStage, nullMeansEmpty);
    }

    @Deprecated
    public static <T> Multi<T> from(Iterable<T> iterable) {
        return Multi.create(iterable);
    }

    @Deprecated
    public static <T> Multi<T> from(Flow.Publisher<T> source) {
        return Multi.create(source);
    }

    @Deprecated
    public static <T> Multi<T> from(Single<T> single) {
        return Multi.create(single);
    }

    @Deprecated
    public static <T> Multi<T> from(Stream<T> stream) {
        return Multi.create(stream);
    }

    public static <T> Multi<T> create(CompletionStage<T> completionStage) {
        return Multi.create(completionStage, false);
    }

    public static <T> Multi<T> create(CompletionStage<T> completionStage, boolean nullMeansEmpty) {
        Objects.requireNonNull(completionStage, "completionStage is null");
        return new MultiFromCompletionStage<T>(completionStage, nullMeansEmpty);
    }

    public static <T> Multi<T> create(Iterable<T> iterable) {
        return new MultiFromIterable<T>(iterable);
    }

    public static <T> Multi<T> create(Flow.Publisher<T> source) {
        if (source instanceof Multi) {
            return (Multi)source;
        }
        return new MultiFromPublisher<T>(source);
    }

    public static <T> Multi<T> create(Single<T> single) {
        return Multi.create(single);
    }

    public static <T> Multi<T> create(Stream<T> stream) {
        Objects.requireNonNull(stream, "stream is null");
        return new MultiFromStream<T>(stream);
    }

    public static Multi<Long> interval(long period, TimeUnit unit, ScheduledExecutorService executor) {
        return Multi.interval(period, period, unit, executor);
    }

    public static Multi<Long> interval(long initialDelay, long period, TimeUnit unit, ScheduledExecutorService executor) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(executor, "executor is null");
        return new MultiInterval(initialDelay, period, unit, executor);
    }

    public static <T> Multi<T> just(Collection<T> items) {
        return Multi.create(items);
    }

    @SafeVarargs
    public static <T> Multi<T> just(T ... items) {
        if (items.length == 0) {
            return Multi.empty();
        }
        if (items.length == 1) {
            return Multi.singleton(items[0]);
        }
        return new MultiFromArrayPublisher<T>(items);
    }

    public static <T> Multi<T> never() {
        return MultiNever.instance();
    }

    public static Multi<Integer> range(int start, int count) {
        if (count < 0) {
            throw new IllegalArgumentException("count >= required");
        }
        if (count == 0) {
            return Multi.empty();
        }
        if (count == 1) {
            return Multi.singleton(start);
        }
        return new MultiRangePublisher(start, start + count);
    }

    public static Multi<Long> rangeLong(long start, long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("count >= required");
        }
        if (count == 0L) {
            return Multi.empty();
        }
        if (count == 1L) {
            return Multi.singleton(start);
        }
        return new MultiRangeLongPublisher(start, start + count);
    }

    public static <T> Multi<T> singleton(T item) {
        Objects.requireNonNull(item, "item is null");
        return new MultiJustPublisher<T>(item);
    }

    public static Multi<Long> timer(long time, TimeUnit unit, ScheduledExecutorService executor) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(executor, "executor is null");
        return new MultiTimer(time, unit, executor);
    }

    default public <U> Single<U> collect(Collector<T, U> collector) {
        return this.collect(() -> collector, Collector::collect).map(Collector::value);
    }

    default public <U> Single<U> collect(Supplier<? extends U> collectionSupplier, BiConsumer<U, T> accumulator) {
        Objects.requireNonNull(collectionSupplier, "collectionSupplier is null");
        Objects.requireNonNull(accumulator, "combiner is null");
        return new MultiCollectPublisher<T, U>(this, collectionSupplier, accumulator);
    }

    default public Single<List<T>> collectList() {
        return this.collect(ArrayList::new, List::add);
    }

    default public <A, R> Single<R> collectStream(java.util.stream.Collector<T, A, R> collector) {
        Objects.requireNonNull(collector, "collector is null");
        return new MultiCollectorPublisher<T, A, R>(this, collector);
    }

    default public <U> Multi<U> compose(Function<? super Multi<T>, ? extends Flow.Publisher<? extends U>> composer) {
        return Multi.create(this.to(composer));
    }

    @Override
    default public Multi<T> defaultIfEmpty(T defaultItem) {
        Objects.requireNonNull(defaultItem, "defaultItem is null");
        return new MultiDefaultIfEmpty<T>(this, defaultItem);
    }

    @Override
    default public Multi<T> defaultIfEmpty(Supplier<? extends T> supplier) {
        Objects.requireNonNull(supplier, "supplier is null");
        return new MultiDeferredDefaultIfEmpty<T>(this, supplier);
    }

    default public Multi<T> distinct() {
        return new MultiDistinctPublisher<Object, Object>(this, v -> v);
    }

    default public Multi<T> dropWhile(Predicate<? super T> predicate) {
        Objects.requireNonNull(predicate, "predicate is null");
        return new MultiDropWhilePublisher<T>(this, predicate);
    }

    default public Multi<T> filter(Predicate<? super T> predicate) {
        return new MultiFilterPublisher<T>(this, predicate);
    }

    default public Single<T> first() {
        return new MultiFirstPublisher(this);
    }

    @Override
    default public <U> Multi<U> flatMap(Function<? super T, ? extends Flow.Publisher<? extends U>> publisherMapper) {
        return new MultiFlatMapPublisher(this, publisherMapper, 32L, 32L, false);
    }

    default public <U> Multi<U> flatMap(Function<? super T, ? extends Flow.Publisher<? extends U>> mapper, long maxConcurrency, boolean delayErrors, long prefetch) {
        return new MultiFlatMapPublisher(this, mapper, maxConcurrency, prefetch, delayErrors);
    }

    default public <U> Multi<U> flatMapCompletionStage(Function<? super T, ? extends CompletionStage<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.flatMap(t -> Multi.create((CompletionStage)mapper.apply(t)), 1L, false, 1L);
    }

    @Override
    default public <U> Multi<U> flatMapIterable(Function<? super T, ? extends Iterable<? extends U>> iterableMapper) {
        return this.flatMapIterable(iterableMapper, 32);
    }

    default public <U> Multi<U> flatMapIterable(Function<? super T, ? extends Iterable<? extends U>> iterableMapper, int prefetch) {
        Objects.requireNonNull(iterableMapper, "iterableMapper is null");
        return new MultiFlatMapIterable(this, iterableMapper, prefetch);
    }

    default public <U> Multi<U> flatMapOptional(Function<? super T, Optional<? extends U>> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return this.flatMap((T t) -> ((Optional)mapper.apply(t)).map((? super T xva$0) -> Multi.just(xva$0)).orElseGet(Multi::empty));
    }

    default public Multi<T> limit(long limit) {
        return new MultiLimitPublisher(this, limit);
    }

    @Override
    default public <U> Multi<U> map(Function<? super T, ? extends U> mapper) {
        Objects.requireNonNull(mapper, "mapper is null");
        return new MultiMapperPublisher<T, U>(this, mapper);
    }

    @Override
    default public Multi<T> observeOn(Executor executor) {
        return this.observeOn(executor, 32, false);
    }

    default public Multi<T> observeOn(Executor executor, int bufferSize, boolean delayError) {
        Objects.requireNonNull(executor, "executor is null");
        if (bufferSize <= 0) {
            throw new IllegalArgumentException("bufferSize > 0 required");
        }
        return new MultiObserveOn(this, executor, bufferSize, delayError);
    }

    @Override
    default public Multi<T> onCancel(Runnable onCancel) {
        return MultiTappedPublisher.builder(this).operatorName("Multi.onCancel").onCancelCallback(onCancel).build();
    }

    @Override
    default public Multi<T> onComplete(Runnable onComplete) {
        return MultiTappedPublisher.builder(this).operatorName("Multi.onComplete").onCompleteCallback(onComplete).build();
    }

    @Override
    default public Multi<T> onError(Consumer<? super Throwable> onErrorConsumer) {
        return MultiTappedPublisher.builder(this).operatorName("Multi.onError").onErrorCallback(onErrorConsumer).build();
    }

    @Override
    default public Multi<T> onErrorResume(Function<? super Throwable, ? extends T> onError) {
        return this.onErrorResumeWith((T e) -> Multi.singleton(onError.apply((Throwable)e)));
    }

    @Override
    default public Multi<T> onErrorResumeWith(Function<? super Throwable, ? extends Flow.Publisher<? extends T>> onError) {
        return new MultiOnErrorResumeWith(this, onError);
    }

    @Override
    default public Multi<T> onCompleteResume(T item) {
        Objects.requireNonNull(item, "item is null");
        return this.onCompleteResumeWith(Multi.singleton(item));
    }

    @Override
    default public Multi<T> onCompleteResumeWith(Flow.Publisher<? extends T> publisher) {
        Objects.requireNonNull(publisher, "publisher is null");
        return new MultiOnCompleteResumeWith<T>(this, publisher);
    }

    @Override
    default public Multi<T> onTerminate(Runnable onTerminate) {
        return MultiTappedPublisher.builder(this).operatorName("Multi.onTerminate").onErrorCallback(t -> onTerminate.run()).onCompleteCallback(onTerminate).onCancelCallback(onTerminate).build();
    }

    default public Multi<T> ifEmpty(Runnable ifEmpty) {
        Objects.requireNonNull(ifEmpty, "ifEmpty callback is null");
        return new MultiIfEmptyPublisher(this, ifEmpty);
    }

    @Override
    default public Multi<T> peek(Consumer<? super T> consumer) {
        return MultiTappedPublisher.builder(this).operatorName("Multi.peek").onNextCallback(consumer).build();
    }

    default public Multi<T> log() {
        return Multi.create(new LoggingPublisher(this, Level.INFO, false));
    }

    default public Multi<T> log(Level level) {
        return Multi.create(new LoggingPublisher(this, level, false));
    }

    default public Multi<T> log(Level level, String loggerName) {
        return Multi.create(new LoggingPublisher(this, level, loggerName));
    }

    default public Multi<T> log(Level level, boolean trace) {
        return Multi.create(new LoggingPublisher(this, level, trace));
    }

    default public Single<T> reduce(BiFunction<T, T, T> reducer) {
        Objects.requireNonNull(reducer, "reducer is null");
        return new MultiReduce<T>(this, reducer);
    }

    default public <R> Single<R> reduce(Supplier<? extends R> supplier, BiFunction<R, T, R> reducer) {
        Objects.requireNonNull(supplier, "supplier is null");
        Objects.requireNonNull(reducer, "reducer is null");
        return new MultiReduceFull<T, R>(this, supplier, reducer);
    }

    @Override
    default public Multi<T> retry(long count) {
        if (count < 0L) {
            throw new IllegalArgumentException("count >= 0L required");
        }
        return new MultiRetry(this, count);
    }

    @Override
    default public Multi<T> retry(BiPredicate<? super Throwable, ? super Long> predicate) {
        Objects.requireNonNull(predicate, "whenFunction is null");
        return new MultiRetry(this, predicate);
    }

    @Override
    default public <U> Multi<T> retryWhen(BiFunction<? super Throwable, ? super Long, ? extends Flow.Publisher<U>> whenFunction) {
        Objects.requireNonNull(whenFunction, "whenFunction is null");
        return new MultiRetry(this, whenFunction);
    }

    default public Multi<T> skip(long skip) {
        return new MultiSkipPublisher(this, skip);
    }

    default public Multi<T> switchIfEmpty(Flow.Publisher<T> other) {
        Objects.requireNonNull(other, "other is null");
        return new MultiSwitchIfEmpty<T>(this, other);
    }

    @Override
    default public <U> Multi<T> takeUntil(Flow.Publisher<U> other) {
        Objects.requireNonNull(other, "other is null");
        return new MultiTakeUntilPublisher(this, other);
    }

    default public Multi<T> takeWhile(Predicate<? super T> predicate) {
        return new MultiTakeWhilePublisher<T>(this, predicate);
    }

    @Override
    default public Multi<T> timeout(long timeout, TimeUnit unit, ScheduledExecutorService executor) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(executor, "executor is null");
        return new MultiTimeout(this, timeout, unit, executor, null);
    }

    default public Multi<T> timeout(long timeout, TimeUnit unit, ScheduledExecutorService executor, Flow.Publisher<T> fallback) {
        Objects.requireNonNull(unit, "unit is null");
        Objects.requireNonNull(executor, "executor is null");
        Objects.requireNonNull(fallback, "fallback is null");
        return new MultiTimeout<T>(this, timeout, unit, executor, fallback);
    }

    default public <U> U to(Function<? super Multi<T>, ? extends U> converter) {
        return converter.apply(this);
    }

    default public Single<Void> forEach(Consumer<? super T> consumer) {
        CompletableFuture future = new CompletableFuture();
        Single<Void> single = Single.create(future, true);
        FunctionalSubscriber<? super T> subscriber = new FunctionalSubscriber<T>(consumer, future::completeExceptionally, () -> future.complete(null), subscription -> {
            single.onCancel(subscription::cancel);
            subscription.request(Long.MAX_VALUE);
        });
        this.subscribe(subscriber);
        return single;
    }

    default public Single<Void> ignoreElements() {
        return this.forEach(t -> {});
    }
}

