/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.Single;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.Function;

final class SingleFlatMapIterable<T, R>
implements Multi<R> {
    private final Single<T> source;
    private final Function<? super T, ? extends Iterable<? extends R>> mapper;

    SingleFlatMapIterable(Single<T> source, Function<? super T, ? extends Iterable<? extends R>> mapper) {
        this.source = source;
        this.mapper = mapper;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super R> subscriber) {
        this.source.subscribe(new FlatMapIterableSubscriber<T, R>(subscriber, this.mapper));
    }

    static final class FlatMapIterableSubscriber<T, R>
    extends AtomicInteger
    implements Flow.Subscriber<T>,
    Flow.Subscription {
        private final Flow.Subscriber<? super R> downstream;
        private final Function<? super T, ? extends Iterable<? extends R>> mapper;
        private final AtomicLong requested;
        private Flow.Subscription upstream;
        private long emitted;
        private volatile int canceled;
        private volatile Iterator<? extends R> iterator;
        private static final int CANCELED = 1;
        private static final int BAD_REQUEST = 2;

        FlatMapIterableSubscriber(Flow.Subscriber<? super R> downstream, Function<? super T, ? extends Iterable<? extends R>> mapper) {
            this.downstream = downstream;
            this.mapper = mapper;
            this.requested = new AtomicLong();
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            this.upstream = subscription;
            this.downstream.onSubscribe(this);
            subscription.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(T item) {
            Flow.Subscription s = this.upstream;
            if (s != SubscriptionHelper.CANCELED) {
                Iterator<R> iterator;
                this.upstream = SubscriptionHelper.CANCELED;
                try {
                    Iterable<R> iterable = Objects.requireNonNull(this.mapper.apply(item), "The mapper returned a null Iterable");
                    iterator = iterable.iterator();
                    if (!iterator.hasNext()) {
                        iterator = null;
                    }
                }
                catch (Throwable ex) {
                    this.downstream.onError(ex);
                    return;
                }
                if (iterator != null) {
                    this.iterator = iterator;
                    this.drain();
                } else {
                    this.downstream.onComplete();
                }
            }
        }

        @Override
        public void onError(Throwable throwable) {
            Flow.Subscription s = this.upstream;
            if (s != SubscriptionHelper.CANCELED) {
                this.upstream = SubscriptionHelper.CANCELED;
                this.downstream.onError(throwable);
            }
        }

        @Override
        public void onComplete() {
            Flow.Subscription s = this.upstream;
            if (s != SubscriptionHelper.CANCELED) {
                this.upstream = SubscriptionHelper.CANCELED;
                this.downstream.onComplete();
            }
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.canceled = 2;
                n = 1L;
            }
            SubscriptionHelper.addRequest(this.requested, n);
            this.drain();
        }

        @Override
        public void cancel() {
            this.canceled = 1;
            this.upstream.cancel();
            this.upstream = SubscriptionHelper.CANCELED;
            this.drain();
        }

        void drain() {
            if (this.getAndIncrement() != 0) {
                return;
            }
            int missed = 1;
            Iterator<R> it = this.iterator;
            Flow.Subscriber<R> downstream = this.downstream;
            long e = this.emitted;
            block4: while (true) {
                int c;
                if ((c = this.canceled) != 0) {
                    it = null;
                    this.iterator = null;
                    if (c == 2) {
                        downstream.onError(new IllegalArgumentException("Rule \u00a73.9 violated: non-positive requests are forbidden"));
                    }
                } else if (it != null) {
                    long r = this.requested.get();
                    while (r != e) {
                        boolean hasNext;
                        R item;
                        try {
                            item = Objects.requireNonNull(it.next(), "The iterator returned a null item");
                        }
                        catch (Throwable ex) {
                            this.canceled = 1;
                            downstream.onError(ex);
                            continue block4;
                        }
                        if (this.canceled != 0) continue block4;
                        downstream.onNext(item);
                        ++e;
                        if (this.canceled != 0) continue block4;
                        try {
                            hasNext = it.hasNext();
                        }
                        catch (Throwable ex) {
                            this.canceled = 1;
                            downstream.onError(ex);
                            continue block4;
                        }
                        if (!hasNext) {
                            this.canceled = 1;
                            downstream.onComplete();
                            continue block4;
                        }
                        if (this.canceled == 0) continue;
                        continue block4;
                    }
                }
                this.emitted = e;
                if ((missed = this.addAndGet(-missed)) == 0) break;
                if (it != null) continue;
                it = this.iterator;
            }
        }
    }
}

