/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.CompletionSingle;
import io.helidon.common.reactive.DeferredScalarSubscription;
import io.helidon.common.reactive.EmptySubscription;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.BiConsumer;
import java.util.function.Function;
import java.util.function.Supplier;
import java.util.stream.Collector;

final class MultiCollectorPublisher<T, A, R>
extends CompletionSingle<R> {
    private final Multi<T> source;
    private final Collector<T, A, R> collector;

    MultiCollectorPublisher(Multi<T> source, Collector<T, A, R> collector) {
        this.source = source;
        this.collector = collector;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super R> subscriber) {
        Function<A, R> finisher;
        BiConsumer<A, T> accumulator;
        Supplier<A> collectionSupplier;
        try {
            collectionSupplier = Objects.requireNonNull(this.collector.supplier(), "The collector.supplier returned a null value");
            accumulator = Objects.requireNonNull(this.collector.accumulator(), "The collector.accumulator returned a null value");
            finisher = Objects.requireNonNull(this.collector.finisher(), "The collector.finisher returned a null value");
        }
        catch (Throwable ex) {
            subscriber.onSubscribe(EmptySubscription.INSTANCE);
            subscriber.onError(ex);
            return;
        }
        this.source.subscribe(new CollectSubscriber<T, A, R>(subscriber, collectionSupplier, accumulator, finisher));
    }

    static final class CollectSubscriber<T, A, R>
    extends DeferredScalarSubscription<R>
    implements Flow.Subscriber<T> {
        private A collection;
        private final Supplier<A> collectionSupplier;
        private final BiConsumer<A, T> accumulator;
        private final Function<A, R> finisher;
        private Flow.Subscription upstream;

        CollectSubscriber(Flow.Subscriber<? super R> downstream, Supplier<A> collectionSupplier, BiConsumer<A, T> accumulator, Function<A, R> finisher) {
            super(downstream);
            this.collectionSupplier = collectionSupplier;
            this.accumulator = accumulator;
            this.finisher = finisher;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            this.upstream = subscription;
            try {
                this.collection = this.collectionSupplier.get();
            }
            catch (Throwable ex) {
                subscription.cancel();
                this.downstream().onSubscribe(EmptySubscription.INSTANCE);
                this.downstream().onError(ex);
                return;
            }
            this.downstream().onSubscribe(this);
            subscription.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(T item) {
            Flow.Subscription s = this.upstream;
            A c = this.collection;
            if (s != SubscriptionHelper.CANCELED && c != null) {
                try {
                    this.accumulator.accept(c, item);
                }
                catch (Throwable ex) {
                    super.cancel();
                    s.cancel();
                    this.onError(ex);
                }
            }
        }

        @Override
        public void onError(Throwable throwable) {
            Flow.Subscription s = this.upstream;
            if (s != SubscriptionHelper.CANCELED) {
                this.collection = null;
                this.upstream = SubscriptionHelper.CANCELED;
                this.downstream().onError(throwable);
            }
        }

        @Override
        public void onComplete() {
            Flow.Subscription s = this.upstream;
            if (s != SubscriptionHelper.CANCELED) {
                A c = this.collection;
                this.collection = null;
                this.upstream = SubscriptionHelper.CANCELED;
                if (c != null) {
                    R result;
                    try {
                        result = Objects.requireNonNull(this.finisher.apply(c), "The finisher returned a null value");
                    }
                    catch (Throwable ex) {
                        this.downstream().onError(ex);
                        return;
                    }
                    this.complete(result);
                }
            }
        }

        @Override
        public void cancel() {
            this.collection = null;
            super.cancel();
            this.upstream.cancel();
            this.upstream = SubscriptionHelper.CANCELED;
        }
    }
}

