/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.EmptySubscription;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.Iterator;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;
import java.util.stream.Stream;

final class MultiFromStream<T>
implements Multi<T> {
    private final Stream<T> stream;

    MultiFromStream(Stream<T> stream) {
        Objects.requireNonNull(stream, "stream is null");
        this.stream = stream;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        boolean hasFirst;
        Iterator iterator;
        Objects.requireNonNull(subscriber, "subscriber is null");
        try {
            iterator = this.stream.iterator();
            hasFirst = iterator.hasNext();
        }
        catch (Throwable ex) {
            block7: {
                subscriber.onSubscribe(EmptySubscription.INSTANCE);
                try {
                    this.stream.close();
                }
                catch (Throwable exc) {
                    if (exc == ex) break block7;
                    ex.addSuppressed(exc);
                }
            }
            subscriber.onError(ex);
            return;
        }
        if (!hasFirst) {
            subscriber.onSubscribe(EmptySubscription.INSTANCE);
            try {
                this.stream.close();
            }
            catch (Throwable ex) {
                subscriber.onError(ex);
                return;
            }
            subscriber.onComplete();
            return;
        }
        subscriber.onSubscribe(new IteratorSubscription<T>(subscriber, iterator, this.stream));
    }

    static final class IteratorSubscription<T>
    extends AtomicLong
    implements Flow.Subscription {
        private final Flow.Subscriber<? super T> downstream;
        private Iterator<T> iterator;
        private AutoCloseable close;
        private volatile int canceled;
        static final int NORMAL_CANCEL = 1;
        static final int BAD_REQUEST = 2;

        IteratorSubscription(Flow.Subscriber<? super T> downstream, Iterator<T> iterator, AutoCloseable close) {
            this.downstream = downstream;
            this.iterator = iterator;
            this.close = close;
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.canceled = 2;
                n = 1L;
            }
            if (SubscriptionHelper.addRequest(this, n) != 0L) {
                return;
            }
            long emitted = 0L;
            Flow.Subscriber<T> downstream = this.downstream;
            while (true) {
                if (emitted != n) {
                    boolean hasNext;
                    T value;
                    int isCanceled = this.canceled;
                    if (isCanceled != 0) {
                        this.iterator = null;
                        if (isCanceled == 2) {
                            downstream.onError(new IllegalArgumentException("Rule \u00a73.9 violated: non-positive request amount is forbidden"));
                        }
                        this.close();
                        return;
                    }
                    try {
                        value = Objects.requireNonNull(this.iterator.next(), "The iterator returned a null value");
                    }
                    catch (Throwable ex) {
                        this.iterator = null;
                        this.canceled = 1;
                        downstream.onError(ex);
                        this.close();
                        return;
                    }
                    if (this.canceled != 0) continue;
                    downstream.onNext(value);
                    if (this.canceled != 0) continue;
                    try {
                        hasNext = this.iterator.hasNext();
                    }
                    catch (Throwable ex) {
                        this.iterator = null;
                        this.canceled = 1;
                        downstream.onError(ex);
                        this.close();
                        return;
                    }
                    if (this.canceled != 0) continue;
                    if (!hasNext) {
                        this.iterator = null;
                        downstream.onComplete();
                        this.close();
                        return;
                    }
                    ++emitted;
                    continue;
                }
                n = this.get();
                if (n != emitted) continue;
                n = SubscriptionHelper.produced(this, emitted);
                if (n == 0L) {
                    return;
                }
                emitted = 0L;
            }
        }

        @Override
        public void cancel() {
            this.canceled = 1;
            this.request(1L);
        }

        void close() {
            AutoCloseable c = this.close;
            this.close = null;
            if (c != null) {
                try {
                    c.close();
                }
                catch (Throwable ex) {
                    Thread t = Thread.currentThread();
                    t.getUncaughtExceptionHandler().uncaughtException(t, ex);
                }
            }
        }
    }
}

