/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import java.util.Objects;
import java.util.concurrent.Flow;

final class MultiSkipPublisher<T>
implements Multi<T> {
    private final Multi<T> source;
    private final long n;

    MultiSkipPublisher(Multi<T> source, long n) {
        this.source = source;
        this.n = Math.max(0L, n);
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Objects.requireNonNull(subscriber, "subscriber is null");
        this.source.subscribe(new SkipSubscriber<T>(subscriber, this.n));
    }

    static final class SkipSubscriber<T>
    implements Flow.Subscriber<T> {
        private final Flow.Subscriber<? super T> downstream;
        private long remaining;
        private Flow.Subscription upstream;

        SkipSubscriber(Flow.Subscriber<? super T> downstream, long remaining) {
            this.downstream = downstream;
            this.remaining = remaining;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            Objects.requireNonNull(subscription, "subscription is null");
            if (this.upstream != null) {
                subscription.cancel();
                throw new IllegalStateException("Subscription already set!");
            }
            long n = this.remaining;
            this.upstream = subscription;
            this.downstream.onSubscribe(subscription);
            if (n != 0L) {
                subscription.request(n);
            }
        }

        @Override
        public void onNext(T item) {
            long n = this.remaining;
            if (n == 0L) {
                this.downstream.onNext(item);
            } else {
                this.remaining = n - 1L;
            }
        }

        @Override
        public void onError(Throwable throwable) {
            this.downstream.onError(throwable);
        }

        @Override
        public void onComplete() {
            this.downstream.onComplete();
        }
    }
}

