/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicLong;

final class MultiRangePublisher
implements Multi<Integer> {
    private final int start;
    private final int end;

    MultiRangePublisher(int start, int end) {
        this.start = start;
        this.end = end;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super Integer> subscriber) {
        subscriber.onSubscribe(new RangeSubscription(subscriber, this.start, this.end));
    }

    static final class RangeSubscription
    extends AtomicLong
    implements Flow.Subscription {
        private final Flow.Subscriber<? super Integer> downstream;
        private int index;
        private final int end;
        private volatile int canceled;
        private static final int CANCELED = 1;
        private static final int BAD_REQUEST = 2;

        RangeSubscription(Flow.Subscriber<? super Integer> downstream, int index, int end) {
            this.downstream = downstream;
            this.index = index;
            this.end = end;
        }

        @Override
        public void request(long n) {
            if (n <= 0L) {
                this.canceled = 2;
                n = 1L;
            }
            if (SubscriptionHelper.addRequest(this, n) != 0L) {
                return;
            }
            long e = 0L;
            int i = this.index;
            int end = this.end;
            Flow.Subscriber<? super Integer> downstream = this.downstream;
            while (true) {
                if (i != end && e != n) {
                    int c = this.canceled;
                    if (c != 0) {
                        if (c == 2) {
                            downstream.onError(new IllegalArgumentException("Rule \u00a73.9 violated: non-positive requests are forbidden."));
                        }
                        return;
                    }
                    downstream.onNext((Integer)i);
                    ++e;
                    ++i;
                    continue;
                }
                if (i == end) {
                    if (this.canceled == 0) {
                        downstream.onComplete();
                    }
                    return;
                }
                n = this.get();
                if (n != e) continue;
                this.index = i;
                if ((n = SubscriptionHelper.produced(this, n)) == 0L) break;
                e = 0L;
            }
        }

        @Override
        public void cancel() {
            this.canceled = 1;
        }
    }
}

