/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.CompletionSingle;
import io.helidon.common.reactive.EmptySubscription;
import io.helidon.common.reactive.Single;
import java.util.Objects;
import java.util.concurrent.Flow;
import java.util.function.Supplier;

final class SingleDefer<T>
extends CompletionSingle<T> {
    private final Supplier<? extends Single<? extends T>> supplier;

    SingleDefer(Supplier<? extends Single<? extends T>> supplier) {
        this.supplier = supplier;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        Single<? super T> publisher;
        try {
            publisher = Objects.requireNonNull(this.supplier.get(), "The supplier returned a null Flow.Publisher");
        }
        catch (Throwable ex) {
            subscriber.onSubscribe(EmptySubscription.INSTANCE);
            subscriber.onError(ex);
            return;
        }
        publisher.subscribe(subscriber);
    }
}

