/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.Single;
import java.util.Objects;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;

final class SingleToFuture<T>
extends CompletableFuture<T>
implements Flow.Subscriber<T> {
    private final AtomicReference<Flow.Subscription> ref = new AtomicReference();
    private final boolean completeWithoutValue;
    private final Single<T> source;

    SingleToFuture(Single<T> source, boolean completeWithoutValue) {
        this.source = source;
        this.completeWithoutValue = completeWithoutValue;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        boolean cancelled = super.cancel(mayInterruptIfRunning);
        if (cancelled) {
            Flow.Subscription s = this.ref.getAndSet(null);
            if (s != null) {
                s.cancel();
            }
            this.source.cancel();
        }
        return cancelled;
    }

    @Override
    public void onSubscribe(Flow.Subscription next) {
        Flow.Subscription current = this.ref.getAndSet(next);
        Objects.requireNonNull(next, "Subscription cannot be null");
        if (current != null) {
            next.cancel();
            current.cancel();
        } else {
            next.request(Long.MAX_VALUE);
        }
    }

    @Override
    public void onNext(T item) {
        Flow.Subscription s = this.ref.getAndSet(null);
        if (s != null) {
            super.complete(item);
        }
    }

    @Override
    public void onError(Throwable ex) {
        if (this.ref.getAndSet(null) != null) {
            super.completeExceptionally(ex);
        }
    }

    @Override
    public void onComplete() {
        if (this.ref.getAndSet(null) != null) {
            if (this.completeWithoutValue) {
                super.complete(null);
            } else {
                super.completeExceptionally(new IllegalStateException("Completed without value"));
            }
        }
    }

    @Override
    public boolean complete(T value) {
        throw new UnsupportedOperationException("This future cannot be completed manually");
    }

    @Override
    public boolean completeExceptionally(Throwable ex) {
        throw new UnsupportedOperationException("This future cannot be completed manually");
    }
}

