/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.DeferredScalarSubscription;
import io.helidon.common.reactive.Multi;
import java.util.concurrent.CompletionStage;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicReference;
import java.util.function.BiConsumer;

final class MultiFromCompletionStage<T>
implements Multi<T> {
    private final CompletionStage<T> source;
    private final boolean nullMeansEmpty;

    MultiFromCompletionStage(CompletionStage<T> source, boolean nullMeansEmpty) {
        this.source = source;
        this.nullMeansEmpty = nullMeansEmpty;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        MultiFromCompletionStage.subscribe(subscriber, this.source, this.nullMeansEmpty);
    }

    static <T> void subscribe(Flow.Subscriber<? super T> subscriber, CompletionStage<T> source, boolean nullMeansEmpty) {
        AtomicBiConsumer watcher = new AtomicBiConsumer();
        CompletionStageSubscription<? super T> css = new CompletionStageSubscription<T>(subscriber, nullMeansEmpty, watcher, source);
        watcher.lazySet(css);
        subscriber.onSubscribe(css);
        source.whenComplete(watcher);
    }

    static final class AtomicBiConsumer<T>
    extends AtomicReference<BiConsumer<T, Throwable>>
    implements BiConsumer<T, Throwable> {
        AtomicBiConsumer() {
        }

        @Override
        public void accept(T t, Throwable throwable) {
            BiConsumer bc = this.getAndSet(null);
            if (bc != null) {
                bc.accept(t, throwable);
            }
        }
    }

    static final class CompletionStageSubscription<T>
    extends DeferredScalarSubscription<T>
    implements BiConsumer<T, Throwable> {
        private final boolean nullMeansEmpty;
        private final AtomicBiConsumer<T> watcher;
        private CompletionStage<T> source;

        CompletionStageSubscription(Flow.Subscriber<? super T> downstream, boolean nullMeansEmpty, AtomicBiConsumer<T> watcher, CompletionStage<T> source) {
            super(downstream);
            this.nullMeansEmpty = nullMeansEmpty;
            this.watcher = watcher;
            this.source = source;
        }

        @Override
        public void accept(T t, Throwable throwable) {
            if (throwable != null) {
                this.error(throwable);
            } else if (t != null) {
                this.complete(t);
            } else if (this.nullMeansEmpty) {
                this.complete();
            } else {
                this.error(new NullPointerException("The CompletionStage completed with a null value"));
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.source.toCompletableFuture().cancel(true);
            this.watcher.getAndSet(null);
        }
    }
}

