/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.concurrent.atomic.AtomicReference;

final class HalfSerializer {
    private static final TerminatedThrowable TERMINATED_EXCEPTION = new TerminatedThrowable();

    private HalfSerializer() {
        throw new IllegalStateException("No instances!");
    }

    public static <T> void onNext(Flow.Subscriber<? super T> downstream, AtomicInteger wip, AtomicReference<Throwable> error, T item) {
        if (wip.compareAndSet(0, 1)) {
            downstream.onNext(item);
            if (wip.decrementAndGet() != 0) {
                Throwable ex = error.getAndSet(TERMINATED_EXCEPTION);
                if (ex != null && ex != TERMINATED_EXCEPTION) {
                    downstream.onError(ex);
                } else {
                    downstream.onComplete();
                }
            }
        }
    }

    public static void onError(Flow.Subscriber<?> downstream, AtomicInteger wip, AtomicReference<Throwable> error, Throwable throwable) {
        if (error.compareAndSet(null, throwable) && wip.getAndIncrement() == 0) {
            error.lazySet(TERMINATED_EXCEPTION);
            downstream.onError(throwable);
        }
    }

    public static void onComplete(Flow.Subscriber<?> downstream, AtomicInteger wip, AtomicReference<Throwable> error) {
        if (wip.getAndIncrement() == 0) {
            Throwable ex = error.getAndSet(TERMINATED_EXCEPTION);
            if (ex != null && ex != TERMINATED_EXCEPTION) {
                downstream.onError(ex);
            } else {
                downstream.onComplete();
            }
        }
    }

    static final class TerminatedThrowable
    extends Throwable {
        TerminatedThrowable() {
            super("Terminated");
        }

        @Override
        public synchronized Throwable fillInStackTrace() {
            return this;
        }
    }
}

