/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.CompletionSingle;
import io.helidon.common.reactive.DeferredScalarSubscription;
import io.helidon.common.reactive.Single;
import io.helidon.common.reactive.SubscriptionHelper;
import io.helidon.common.reactive.TerminatedFuture;
import java.util.concurrent.Callable;
import java.util.concurrent.Flow;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicReference;

final class SingleTimeout<T>
extends CompletionSingle<T> {
    private final Single<T> source;
    private final long timeout;
    private final TimeUnit unit;
    private final ScheduledExecutorService executor;
    private final Single<T> fallback;

    SingleTimeout(Single<T> source, long timeout, TimeUnit unit, ScheduledExecutorService executor, Single<T> fallback) {
        this.source = source;
        this.timeout = timeout;
        this.unit = unit;
        this.executor = executor;
        this.fallback = fallback;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        TimeoutSubscriber<T> parent = new TimeoutSubscriber<T>(subscriber, this.fallback);
        subscriber.onSubscribe(parent);
        parent.setFuture(this.executor.schedule(parent, this.timeout, this.unit));
        this.source.subscribe(parent);
    }

    static final class TimeoutSubscriber<T>
    extends DeferredScalarSubscription<T>
    implements Flow.Subscriber<T>,
    Callable<Void> {
        private final Single<T> fallback;
        private final AtomicBoolean once;
        private final AtomicReference<Future<?>> future;
        private final AtomicReference<Flow.Subscription> upstream;
        private final FallbackSubscriber<T> fallbackSubscriber;

        TimeoutSubscriber(Flow.Subscriber<? super T> downstream, Single<T> fallback) {
            super(downstream);
            this.fallback = fallback;
            this.once = new AtomicBoolean();
            this.future = new AtomicReference();
            this.upstream = new AtomicReference();
            this.fallbackSubscriber = new FallbackSubscriber(this);
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            if (SubscriptionHelper.setOnce(this.upstream, subscription)) {
                subscription.request(Long.MAX_VALUE);
            }
        }

        @Override
        public void onNext(T item) {
            if (this.once.compareAndSet(false, true)) {
                TerminatedFuture.cancel(this.future);
                this.complete(item);
            }
        }

        @Override
        public void onError(Throwable throwable) {
            if (this.once.compareAndSet(false, true)) {
                TerminatedFuture.cancel(this.future);
                this.error(throwable);
            }
        }

        @Override
        public void onComplete() {
            if (this.once.compareAndSet(false, true)) {
                TerminatedFuture.cancel(this.future);
                this.complete();
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            TerminatedFuture.cancel(this.future);
            SubscriptionHelper.cancel(this.upstream);
            SubscriptionHelper.cancel(this.fallbackSubscriber);
        }

        @Override
        public Void call() {
            if (this.once.compareAndSet(false, true)) {
                this.future.lazySet(TerminatedFuture.FINISHED);
                SubscriptionHelper.cancel(this.upstream);
                if (this.fallback == null) {
                    this.error(new TimeoutException());
                } else {
                    this.fallback.subscribe(this.fallbackSubscriber);
                }
            }
            return null;
        }

        public void setFuture(Future<?> f) {
            TerminatedFuture.setFuture(this.future, f);
        }

        static final class FallbackSubscriber<T>
        extends AtomicReference<Flow.Subscription>
        implements Flow.Subscriber<T> {
            private final TimeoutSubscriber<T> parent;

            FallbackSubscriber(TimeoutSubscriber<T> parent) {
                this.parent = parent;
            }

            @Override
            public void onSubscribe(Flow.Subscription subscription) {
                if (SubscriptionHelper.setOnce(this, subscription)) {
                    subscription.request(Long.MAX_VALUE);
                }
            }

            @Override
            public void onNext(T item) {
                this.parent.complete(item);
            }

            @Override
            public void onError(Throwable throwable) {
                this.parent.error(throwable);
            }

            @Override
            public void onComplete() {
                this.parent.complete();
            }
        }
    }
}

