/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.CompletionSingle;
import io.helidon.common.reactive.MultiTimer;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;

final class SingleTimer
extends CompletionSingle<Long> {
    private final long time;
    private final TimeUnit unit;
    private final ScheduledExecutorService executor;

    SingleTimer(long time, TimeUnit unit, ScheduledExecutorService executor) {
        this.time = time;
        this.unit = unit;
        this.executor = executor;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super Long> subscriber) {
        MultiTimer.TimerSubscription subscription = new MultiTimer.TimerSubscription(subscriber);
        subscriber.onSubscribe(subscription);
        subscription.setFuture(this.executor.schedule(subscription, this.time, this.unit));
    }
}

