/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.CompletionSingle;
import io.helidon.common.reactive.EmptySubscription;
import java.util.Objects;
import java.util.concurrent.Flow;

final class SingleError<T>
extends CompletionSingle<T> {
    private final Throwable error;

    SingleError(Throwable error) {
        this.error = Objects.requireNonNull(error, "error cannot be null!");
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        subscriber.onSubscribe(EmptySubscription.INSTANCE);
        subscriber.onError(this.error);
    }

    Throwable getError() {
        return this.error;
    }
}

