/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.Builder;
import io.helidon.common.LazyValue;
import io.helidon.common.reactive.ByteChannelSubscriber;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.MultiFromBlockingInputStream;
import io.helidon.common.reactive.MultiFromByteChannel;
import io.helidon.common.reactive.MultiFromInputStream;
import io.helidon.common.reactive.OutputStreamMulti;
import io.helidon.common.reactive.RetrySchema;
import io.helidon.common.reactive.Single;
import java.io.IOException;
import java.io.InputStream;
import java.io.UncheckedIOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.ReadableByteChannel;
import java.nio.channels.WritableByteChannel;
import java.nio.file.Path;
import java.nio.file.StandardOpenOption;
import java.time.Duration;
import java.util.Objects;
import java.util.concurrent.Executor;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import java.util.function.BiConsumer;
import java.util.function.Function;

public interface IoMulti {
    @Deprecated(since="2.0.0", forRemoval=true)
    public static OutputStreamMulti createOutputStream() {
        return new OutputStreamMulti();
    }

    public static OutputStreamMulti outputStreamMulti() {
        return new OutputStreamMulti();
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    public static OutputStreamMultiBuilder builderOutputStream() {
        return new OutputStreamMultiBuilder();
    }

    public static OutputStreamMultiBuilder outputStreamMultiBuilder() {
        return new OutputStreamMultiBuilder();
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    public static Multi<ByteBuffer> createInputStream(InputStream inputStream) {
        return IoMulti.builderInputStream(inputStream).build();
    }

    public static Multi<ByteBuffer> multiFromStream(InputStream inputStream) {
        return IoMulti.builderInputStream(inputStream).build();
    }

    @Deprecated(since="2.0.0", forRemoval=true)
    public static MultiFromInputStreamBuilder builderInputStream(InputStream inputStream) {
        Objects.requireNonNull(inputStream);
        return new MultiFromInputStreamBuilder(inputStream);
    }

    public static MultiFromInputStreamBuilder multiFromStreamBuilder(InputStream inputStream) {
        Objects.requireNonNull(inputStream);
        return new MultiFromInputStreamBuilder(inputStream);
    }

    public static Multi<ByteBuffer> multiFromByteChannel(ReadableByteChannel byteChannel) {
        return IoMulti.multiFromByteChannelBuilder(byteChannel).build();
    }

    public static Function<? super Multi<ByteBuffer>, ? extends Single<Void>> multiToByteChannel(WritableByteChannel writableChannel) {
        return IoMulti.multiToByteChannelBuilder(writableChannel).build();
    }

    public static MultiToByteChannelBuilder multiToByteChannelBuilder(WritableByteChannel byteChannel) {
        return new MultiToByteChannelBuilder(byteChannel);
    }

    public static MultiToByteChannelBuilder writeToFile(Path filePath) {
        try {
            FileChannel fileChannel = FileChannel.open(filePath, StandardOpenOption.WRITE);
            return new MultiToByteChannelBuilder(fileChannel);
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
    }

    public static MultiFromByteChannelBuilder multiFromByteChannelBuilder(ReadableByteChannel byteChannel) {
        return new MultiFromByteChannelBuilder(Objects.requireNonNull(byteChannel));
    }

    public static final class OutputStreamMultiBuilder
    implements Builder<OutputStreamMultiBuilder, OutputStreamMulti> {
        private Duration timeout;
        private BiConsumer<Long, Long> consumer;

        private OutputStreamMultiBuilder() {
        }

        @Deprecated(since="4.0.0")
        public OutputStreamMultiBuilder timeout(long timeout, TimeUnit unit) {
            this.timeout = Duration.of(timeout, unit.toChronoUnit());
            return this;
        }

        public OutputStreamMultiBuilder timeout(Duration timeout) {
            this.timeout = timeout;
            return this;
        }

        public OutputStreamMultiBuilder onRequest(BiConsumer<Long, Long> requestCallback) {
            this.consumer = requestCallback;
            return this;
        }

        public OutputStreamMulti build() {
            OutputStreamMulti response = new OutputStreamMulti();
            if (this.consumer != null) {
                response.onRequest(this.consumer);
            }
            if (this.timeout != null) {
                response.timeout(this.timeout);
            }
            return response;
        }
    }

    public static final class MultiFromInputStreamBuilder
    implements Builder<MultiFromInputStreamBuilder, Multi<ByteBuffer>> {
        private int bufferSize = 1024;
        private ExecutorService executor;
        private final InputStream inputStream;

        MultiFromInputStreamBuilder(InputStream inputStream) {
            this.inputStream = inputStream;
        }

        public MultiFromInputStreamBuilder byteBufferSize(int bufferSize) {
            this.bufferSize = bufferSize;
            return this;
        }

        public MultiFromInputStreamBuilder executor(ExecutorService executor) {
            Objects.requireNonNull(executor);
            this.executor = executor;
            return this;
        }

        public Multi<ByteBuffer> build() {
            if (this.executor != null) {
                return new MultiFromBlockingInputStream(this.inputStream, this.bufferSize, this.executor);
            }
            return new MultiFromInputStream(this.inputStream, this.bufferSize);
        }
    }

    public static final class MultiFromByteChannelBuilder
    implements Builder<MultiFromByteChannelBuilder, Multi<ByteBuffer>> {
        private static final int DEFAULT_BUFFER_CAPACITY = 8192;
        private static final RetrySchema DEFAULT_RETRY_SCHEMA = RetrySchema.linear(0L, 10L, 250L);
        private static final String THREAD_PREFIX = "multi-rbc-";
        private static final AtomicLong COUNTER = new AtomicLong();
        private static final ThreadFactory THREAD_FACTORY = r -> new Thread(r, THREAD_PREFIX + COUNTER.incrementAndGet());
        private final ReadableByteChannel theChannel;
        private LazyValue<ScheduledExecutorService> executor = LazyValue.create(() -> Executors.newScheduledThreadPool(1, THREAD_FACTORY));
        private RetrySchema retrySchema = DEFAULT_RETRY_SCHEMA;
        private int bufferCapacity = 8192;
        private boolean externalExecutor;

        private MultiFromByteChannelBuilder(ReadableByteChannel theChannel) {
            this.theChannel = theChannel;
        }

        public Multi<ByteBuffer> build() {
            return new MultiFromByteChannel(this);
        }

        public MultiFromByteChannelBuilder executor(ScheduledExecutorService executor) {
            Objects.requireNonNull(executor);
            this.executor = LazyValue.create((Object)executor);
            this.externalExecutor = true;
            return this;
        }

        public MultiFromByteChannelBuilder retrySchema(RetrySchema retrySchema) {
            Objects.requireNonNull(retrySchema);
            this.retrySchema = retrySchema;
            return this;
        }

        public MultiFromByteChannelBuilder bufferCapacity(int bufferCapacity) {
            this.bufferCapacity = bufferCapacity;
            return this;
        }

        ReadableByteChannel theChannel() {
            return this.theChannel;
        }

        LazyValue<ScheduledExecutorService> executor() {
            return this.executor;
        }

        RetrySchema retrySchema() {
            return this.retrySchema;
        }

        int bufferCapacity() {
            return this.bufferCapacity;
        }

        boolean isExternalExecutor() {
            return this.externalExecutor;
        }
    }

    public static final class MultiToByteChannelBuilder
    implements Builder<MultiToByteChannelBuilder, Function<? super Multi<ByteBuffer>, ? extends Single<Void>>> {
        private final WritableByteChannel writableByteChannel;
        private Executor executor;

        private MultiToByteChannelBuilder(WritableByteChannel writableByteChannel) {
            this.writableByteChannel = writableByteChannel;
        }

        public MultiToByteChannelBuilder executor(Executor executor) {
            this.executor = executor;
            return this;
        }

        public Function<? super Multi<ByteBuffer>, ? extends Single<Void>> build() {
            if (this.executor == null) {
                return byteBufferMulti -> {
                    ByteChannelSubscriber byteChannelSubscriber = new ByteChannelSubscriber(this.writableByteChannel, Executors.newSingleThreadExecutor());
                    byteBufferMulti.subscribe(byteChannelSubscriber);
                    return byteChannelSubscriber;
                };
            }
            return byteBufferMulti -> {
                ByteChannelSubscriber byteChannelSubscriber = new ByteChannelSubscriber(this.writableByteChannel, this.executor);
                byteBufferMulti.subscribe(byteChannelSubscriber);
                return byteChannelSubscriber;
            };
        }
    }
}

