/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.LazyValue;
import io.helidon.common.reactive.IoMulti;
import io.helidon.common.reactive.Multi;
import io.helidon.common.reactive.RequestedCounter;
import io.helidon.common.reactive.RetrySchema;
import io.helidon.common.reactive.SingleSubscriberHolder;
import java.nio.ByteBuffer;
import java.nio.channels.ReadableByteChannel;
import java.util.concurrent.Flow;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.logging.Level;
import java.util.logging.Logger;

class MultiFromByteChannel
implements Multi<ByteBuffer> {
    private static final Logger LOGGER = Logger.getLogger(MultiFromByteChannel.class.getName());
    private final ReadableByteChannel channel;
    private final RetrySchema retrySchema;
    private final boolean externalExecutor;
    private final int chunkCapacity;
    private final LazyValue<ScheduledExecutorService> executor;
    private final SingleSubscriberHolder<ByteBuffer> subscriber = SingleSubscriberHolder.create();
    private final RequestedCounter requested = new RequestedCounter();
    private final AtomicBoolean publishing = new AtomicBoolean(false);
    private final AtomicInteger retryCounter = new AtomicInteger();
    private volatile long lastRetryDelay = 0L;
    private volatile ByteBuffer currentBuffer;

    MultiFromByteChannel(IoMulti.MultiFromByteChannelBuilder builder) {
        this.channel = builder.theChannel();
        this.retrySchema = builder.retrySchema();
        this.executor = builder.executor();
        this.externalExecutor = builder.isExternalExecutor();
        this.chunkCapacity = builder.bufferCapacity();
    }

    @Override
    public void subscribe(Flow.Subscriber<? super ByteBuffer> subscriberParam) {
        if (this.subscriber.register(subscriberParam)) {
            this.publishing.set(true);
            try {
                subscriberParam.onSubscribe(new Flow.Subscription(){

                    @Override
                    public void request(long n) {
                        MultiFromByteChannel.this.requested.increment(n, t -> MultiFromByteChannel.this.tryComplete((Throwable)t));
                        MultiFromByteChannel.this.tryPublish();
                    }

                    @Override
                    public void cancel() {
                        MultiFromByteChannel.this.subscriber.cancel();
                        MultiFromByteChannel.this.closeExecutor();
                    }
                });
            }
            finally {
                this.publishing.set(false);
            }
            this.tryPublish();
        }
    }

    LazyValue<ScheduledExecutorService> executor() {
        return this.executor;
    }

    private ByteBuffer allocateNewBuffer() {
        return ByteBuffer.allocate(this.chunkCapacity);
    }

    private boolean publishSingleOrFinish(Flow.Subscriber<? super ByteBuffer> subscr) throws Exception {
        ByteBuffer bb;
        if (this.currentBuffer == null) {
            bb = this.allocateNewBuffer();
        } else {
            bb = this.currentBuffer;
            this.currentBuffer = null;
        }
        int count = 0;
        while (bb.remaining() > 0 && (count = this.channel.read(bb)) > 0) {
        }
        if (bb.capacity() > bb.remaining()) {
            bb.flip();
            subscr.onNext(bb);
        } else {
            this.currentBuffer = bb;
        }
        if (count < 0) {
            try {
                this.channel.close();
            }
            catch (Exception e) {
                LOGGER.log(Level.WARNING, "Cannot close readable byte channel! (Close attempt after fully read channel.)", e);
            }
            this.tryComplete();
            return true;
        }
        return count > 0;
    }

    private void tryPublish() {
        boolean immediateRetry = true;
        while (immediateRetry) {
            long nextDelay;
            immediateRetry = false;
            if (this.subscriber.isClosed() || this.requested.get() <= 0L || !this.publishing.compareAndSet(false, true)) continue;
            try {
                Flow.Subscriber<ByteBuffer> sub = this.subscriber.get();
                while (!this.subscriber.isClosed() && this.requested.tryDecrement()) {
                    if (this.publishSingleOrFinish(sub)) continue;
                    this.requested.increment(1L, this::tryComplete);
                    break;
                }
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                this.tryComplete(e);
            }
            catch (Exception e) {
                this.tryComplete(e);
            }
            finally {
                this.publishing.set(false);
            }
            if (this.subscriber.isClosed() || this.requested.get() <= 0L) continue;
            this.lastRetryDelay = nextDelay = this.retrySchema.nextDelay(this.retryCounter.getAndIncrement(), this.lastRetryDelay);
            if (nextDelay < 0L) {
                this.tryComplete(new TimeoutException("Wait for the next item timeout!"));
                continue;
            }
            if (nextDelay == 0L) {
                immediateRetry = true;
                continue;
            }
            this.planNextTry(nextDelay);
        }
    }

    private synchronized void planNextTry(long afterMillis) {
        ((ScheduledExecutorService)this.executor.get()).schedule(this::tryPublish, afterMillis, TimeUnit.MILLISECONDS);
    }

    private void tryComplete() {
        this.subscriber.close(Flow.Subscriber::onComplete);
        this.closeExecutor();
    }

    private void tryComplete(Throwable t) {
        this.subscriber.close(sub -> sub.onError(t));
        this.closeExecutor();
    }

    private synchronized void closeExecutor() {
        if (!this.externalExecutor && this.executor.isLoaded()) {
            ((ScheduledExecutorService)this.executor.get()).shutdownNow();
        }
    }
}

