/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import io.helidon.common.reactive.CompletionSingle;
import io.helidon.common.reactive.DeferredScalarSubscription;
import io.helidon.common.reactive.Single;
import io.helidon.common.reactive.SubscriptionHelper;
import java.util.concurrent.Flow;

final class SingleDefaultIfEmpty<T>
extends CompletionSingle<T> {
    private final Single<T> source;
    private final T defaultItem;

    SingleDefaultIfEmpty(Single<T> source, T defaultItem) {
        this.source = source;
        this.defaultItem = defaultItem;
    }

    @Override
    public void subscribe(Flow.Subscriber<? super T> subscriber) {
        this.source.subscribe(new DefaultIfEmptySubscriber<T>(subscriber, this.defaultItem));
    }

    static final class DefaultIfEmptySubscriber<T>
    extends DeferredScalarSubscription<T>
    implements Flow.Subscriber<T> {
        private final T defaultItem;
        private Flow.Subscription upstream;

        DefaultIfEmptySubscriber(Flow.Subscriber<? super T> downstream, T defaultItem) {
            super(downstream);
            this.defaultItem = defaultItem;
        }

        @Override
        public void onSubscribe(Flow.Subscription subscription) {
            SubscriptionHelper.validate(this.upstream, subscription);
            this.upstream = subscription;
            this.subscribeSelf();
            subscription.request(Long.MAX_VALUE);
        }

        @Override
        public void onNext(T item) {
            this.upstream = SubscriptionHelper.CANCELED;
            this.complete(item);
        }

        @Override
        public void onError(Throwable throwable) {
            this.error(throwable);
        }

        @Override
        public void onComplete() {
            if (this.upstream != SubscriptionHelper.CANCELED) {
                this.complete(this.defaultItem);
            }
        }

        @Override
        public void cancel() {
            super.cancel();
            this.upstream.cancel();
        }
    }
}

