/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.reactive;

import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Flow;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.function.Consumer;

public class SingleSubscriberHolder<T> {
    private static final IllegalStateException ALREADY_CLOSED = new IllegalStateException("Publisher already closed.");
    private static final IllegalStateException CANCELLED = new IllegalStateException("Canceled before any subscriber is registered!");
    private final CompletableFuture<Flow.Subscriber<? super T>> subscriber = new CompletableFuture();
    private final AtomicBoolean closed = new AtomicBoolean(false);
    private final AtomicBoolean onSubscribeCalled = new AtomicBoolean(false);

    @Deprecated(forRemoval=true, since="4.0.9")
    public SingleSubscriberHolder() {
    }

    public static <T> SingleSubscriberHolder<T> create() {
        return new SingleSubscriberHolder<T>();
    }

    public boolean register(Flow.Subscriber<? super T> subscriber) {
        if (this.subscriber.complete(subscriber)) {
            return true;
        }
        Throwable error = null;
        try {
            this.subscriber.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            error = e;
        }
        catch (ExecutionException e) {
            error = e.getCause();
        }
        subscriber.onError(error != null ? error : new IllegalStateException("This publisher only supports a single subscriber!"));
        return false;
    }

    public void close(Consumer<Flow.Subscriber<? super T>> completionHandler) {
        if (!this.subscriber.completeExceptionally(ALREADY_CLOSED) && this.closed.compareAndSet(false, true)) {
            try {
                Flow.Subscriber<? super T> s = this.subscriber.get();
                completionHandler.accept(s);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
            catch (ExecutionException executionException) {
                // empty catch block
            }
        }
    }

    public void cancel() {
        this.subscriber.completeExceptionally(CANCELLED);
        this.closed.set(true);
    }

    public Flow.Subscriber<? super T> get() throws InterruptedException, ExecutionException {
        return this.subscriber.get();
    }

    public boolean isClosed() {
        return this.closed.get();
    }

    boolean isReady() {
        return this.subscriber.isDone() && !this.isClosed();
    }

    boolean onSubscribedCalled() {
        return this.onSubscribeCalled.get();
    }

    boolean tryOnSubscribe(Flow.Subscription subscription) {
        if (this.isReady() && !this.onSubscribeCalled.getAndSet(true)) {
            this.subscriber.whenComplete((s, t) -> s.onSubscribe(subscription));
            return true;
        }
        return false;
    }
}

