/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.socket;

import io.helidon.common.LazyValue;
import io.helidon.common.socket.PeerInfo;
import io.helidon.common.socket.PlainSocket;
import io.helidon.common.socket.TlsSocket;
import java.net.SocketAddress;
import java.security.Principal;
import java.security.cert.Certificate;
import java.util.Optional;

class PeerInfoImpl
implements PeerInfo {
    private final LazyValue<SocketAddress> socketAddress;
    private final LazyValue<String> host;
    private final LazyValue<Integer> port;
    private final LazyValue<Optional<Principal>> principalSupplier;
    private final LazyValue<Optional<Certificate[]>> certificateSupplier;

    private PeerInfoImpl(LazyValue<SocketAddress> socketAddress, LazyValue<String> host, LazyValue<Integer> port, LazyValue<Optional<Principal>> principalSupplier, LazyValue<Optional<Certificate[]>> certificateSupplier) {
        this.socketAddress = socketAddress;
        this.host = host;
        this.port = port;
        this.principalSupplier = principalSupplier;
        this.certificateSupplier = certificateSupplier;
    }

    static PeerInfo createLocal(PlainSocket socket) {
        return new PeerInfoImpl((LazyValue<SocketAddress>)LazyValue.create(socket::localSocketAddress), (LazyValue<String>)LazyValue.create(socket::localHost), (LazyValue<Integer>)LazyValue.create(socket::localPort), (LazyValue<Optional<Principal>>)LazyValue.create(Optional.empty()), (LazyValue<Optional<Certificate[]>>)LazyValue.create(Optional.empty()));
    }

    static PeerInfoImpl createLocal(TlsSocket socket) {
        return new PeerInfoImpl((LazyValue<SocketAddress>)LazyValue.create(socket::localSocketAddress), (LazyValue<String>)LazyValue.create(socket::localHost), (LazyValue<Integer>)LazyValue.create(socket::localPort), (LazyValue<Optional<Principal>>)LazyValue.create(socket::tlsPrincipal), (LazyValue<Optional<Certificate[]>>)LazyValue.create(socket::tlsCertificates));
    }

    static PeerInfoImpl createRemote(TlsSocket socket) {
        return new PeerInfoImpl((LazyValue<SocketAddress>)LazyValue.create(socket::remoteSocketAddress), (LazyValue<String>)LazyValue.create(socket::remoteHost), (LazyValue<Integer>)LazyValue.create(socket::remotePort), (LazyValue<Optional<Principal>>)LazyValue.create(socket::tlsPeerPrincipal), (LazyValue<Optional<Certificate[]>>)LazyValue.create(socket::tlsPeerCertificates));
    }

    static PeerInfoImpl createRemote(PlainSocket socket) {
        return new PeerInfoImpl((LazyValue<SocketAddress>)LazyValue.create(socket::remoteSocketAddress), (LazyValue<String>)LazyValue.create(socket::remoteHost), (LazyValue<Integer>)LazyValue.create(socket::remotePort), (LazyValue<Optional<Principal>>)LazyValue.create(Optional.empty()), (LazyValue<Optional<Certificate[]>>)LazyValue.create(Optional.empty()));
    }

    @Override
    public SocketAddress address() {
        return (SocketAddress)this.socketAddress.get();
    }

    @Override
    public String host() {
        return (String)this.host.get();
    }

    @Override
    public int port() {
        return (Integer)this.port.get();
    }

    @Override
    public Optional<Principal> tlsPrincipal() {
        return (Optional)this.principalSupplier.get();
    }

    @Override
    public Optional<Certificate[]> tlsCertificates() {
        return (Optional)this.certificateSupplier.get();
    }
}

