/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.tls;

import io.helidon.builder.api.Option;
import io.helidon.builder.api.Prototype;
import io.helidon.common.pki.Keys;
import io.helidon.common.tls.Tls;
import io.helidon.common.tls.TlsClientAuth;
import io.helidon.common.tls.TlsConfigDecorator;
import io.helidon.common.tls.TlsManager;
import io.helidon.common.tls.spi.TlsManagerProvider;
import io.helidon.config.metadata.Configured;
import io.helidon.config.metadata.ConfiguredOption;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.time.Duration;
import java.util.List;
import java.util.Optional;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLParameters;

@Prototype.Blueprint(decorator=TlsConfigDecorator.class)
@Configured
interface TlsConfigBlueprint
extends Prototype.Factory<Tls> {
    public static final String DEFAULT_PROTOCOL = "TLS";

    @Prototype.FactoryMethod
    public static Optional<PrivateKey> createPrivateKey(Keys config) {
        return config.privateKey();
    }

    @Prototype.FactoryMethod
    public static List<X509Certificate> createPrivateKeyCertChain(Keys config) {
        return config.certChain();
    }

    @Prototype.FactoryMethod
    public static List<X509Certificate> createTrust(Keys config) {
        return config.certs();
    }

    public Optional<SSLContext> sslContext();

    @ConfiguredOption
    public Optional<PrivateKey> privateKey();

    @Option.Singular
    @ConfiguredOption(key="private-key")
    public List<X509Certificate> privateKeyCertChain();

    @Option.Singular
    @ConfiguredOption
    public List<X509Certificate> trust();

    @ConfiguredOption(provider=true, providerType=TlsManagerProvider.class, providerDiscoverServices=false)
    public TlsManager manager();

    public Optional<SecureRandom> secureRandom();

    public Optional<SSLParameters> sslParameters();

    @ConfiguredOption
    public Optional<String> secureRandomProvider();

    @ConfiguredOption
    public Optional<String> secureRandomAlgorithm();

    @ConfiguredOption
    public Optional<String> keyManagerFactoryAlgorithm();

    public Optional<String> keyManagerFactoryProvider();

    @ConfiguredOption
    public Optional<String> trustManagerFactoryAlgorithm();

    public Optional<String> trustManagerFactoryProvider();

    @Option.Singular
    public List<String> applicationProtocols();

    @ConfiguredOption(value="HTTPS")
    public String endpointIdentificationAlgorithm();

    @ConfiguredOption(value="true")
    public boolean enabled();

    @ConfiguredOption(value="false")
    public boolean trustAll();

    @ConfiguredOption(value="NONE")
    public TlsClientAuth clientAuth();

    @ConfiguredOption(value="TLS")
    public String protocol();

    @ConfiguredOption
    public Optional<String> provider();

    @ConfiguredOption(key="cipher-suite")
    @Option.Singular(value="enabledCipherSuite")
    public List<String> enabledCipherSuites();

    @ConfiguredOption(key="protocols")
    @Option.Singular
    public List<String> enabledProtocols();

    @ConfiguredOption(value="1024")
    public int sessionCacheSize();

    @ConfiguredOption(value="PT30M")
    public Duration sessionTimeout();

    @ConfiguredOption
    public Optional<String> internalKeystoreType();

    @ConfiguredOption
    public Optional<String> internalKeystoreProvider();
}

