/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.tls;

import io.helidon.common.tls.Tls;
import io.helidon.common.tls.TlsReloadableComponent;
import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import java.util.Objects;
import javax.net.ssl.X509TrustManager;

class TlsReloadableX509TrustManager
implements X509TrustManager,
TlsReloadableComponent {
    private static final System.Logger LOGGER = System.getLogger(TlsReloadableX509TrustManager.class.getName());
    private volatile X509TrustManager trustManager;

    private TlsReloadableX509TrustManager(X509TrustManager trustManager) {
        this.trustManager = trustManager;
    }

    @Override
    public void checkClientTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkClientTrusted(chain, authType);
    }

    @Override
    public void checkServerTrusted(X509Certificate[] chain, String authType) throws CertificateException {
        this.trustManager.checkServerTrusted(chain, authType);
    }

    @Override
    public X509Certificate[] getAcceptedIssuers() {
        return this.trustManager.getAcceptedIssuers();
    }

    @Override
    public void reload(Tls tls) {
        tls.trustManager().ifPresent(this::reload);
    }

    void reload(X509TrustManager trustManager) {
        Objects.requireNonNull(trustManager, "Cannot unset trust store");
        TlsReloadableX509TrustManager.assertValid(trustManager);
        LOGGER.log(System.Logger.Level.DEBUG, "Reloading TLS X509TrustManager");
        this.trustManager = trustManager;
    }

    static TlsReloadableX509TrustManager create(X509TrustManager trustManager) {
        if (trustManager instanceof TlsReloadableX509TrustManager) {
            return (TlsReloadableX509TrustManager)trustManager;
        }
        TlsReloadableX509TrustManager.assertValid(trustManager);
        return new TlsReloadableX509TrustManager(trustManager);
    }

    static void assertValid(X509TrustManager trustManager) {
        if (trustManager instanceof TlsReloadableX509TrustManager) {
            throw new IllegalArgumentException();
        }
    }

    static class NotReloadableTrustManager
    extends TlsReloadableX509TrustManager {
        NotReloadableTrustManager() {
            super(null);
        }

        @Override
        public void reload(Tls tls) {
            if (tls.trustManager().isPresent()) {
                throw new UnsupportedOperationException("Cannot set trust manager if one was not set during server start");
            }
        }

        @Override
        void reload(X509TrustManager trustManager) {
            throw new UnsupportedOperationException("Cannot set trust manager if one was not set during server start");
        }
    }
}

