/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.uri;

import io.helidon.common.parameters.Parameters;
import io.helidon.common.uri.UriMatrixParameters;
import io.helidon.common.uri.UriPathNoParam;
import java.net.URI;
import java.util.Objects;

class UriPathMatrix
extends UriPathNoParam {
    private final String rawPath;
    private Parameters pathParams;

    UriPathMatrix(String rawPath, String noParamPath) {
        super(noParamPath);
        this.rawPath = rawPath;
    }

    @Override
    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        UriPathMatrix that = (UriPathMatrix)o;
        return Objects.equals(this.rawPath, that.rawPath) && Objects.equals(this.matrixParameters(), that.matrixParameters());
    }

    @Override
    public int hashCode() {
        return Objects.hash(super.hashCode(), this.rawPath, this.matrixParameters());
    }

    @Override
    public String rawPath() {
        return this.rawPath;
    }

    @Override
    public Parameters matrixParameters() {
        if (this.pathParams == null) {
            this.pathParams = UriMatrixParameters.create(this.rawPath);
        }
        return this.pathParams;
    }

    @Override
    public void validate() {
        URI.create(this.rawPath);
        super.validate();
    }
}

