/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common.uri;

import io.helidon.common.GenericType;
import io.helidon.common.mapper.MapperManager;
import io.helidon.common.mapper.OptionalValue;
import io.helidon.common.mapper.Value;
import io.helidon.common.uri.UriEncoding;
import io.helidon.common.uri.UriQuery;
import io.helidon.common.uri.UriQueryWriteable;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.function.Consumer;
import java.util.stream.Collectors;

final class UriQueryWriteableImpl
implements UriQueryWriteable {
    private final Map<String, List<String>> rawQueryParams = new HashMap<String, List<String>>();
    private final Map<String, List<String>> decodedQueryParams = new HashMap<String, List<String>>();

    UriQueryWriteableImpl() {
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof UriQuery)) {
            return false;
        }
        UriQuery that = (UriQuery)o;
        if (!Objects.equals(this.names(), that.names())) {
            return false;
        }
        for (String name : this.names()) {
            if (Objects.equals(this.all(name), that.all(name))) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        return Objects.hashCode(this.decodedQueryParams);
    }

    @Override
    public UriQueryWriteable from(UriQuery uriQuery) {
        if (uriQuery instanceof UriQueryWriteableImpl) {
            UriQueryWriteableImpl impl = (UriQueryWriteableImpl)uriQuery;
            impl.rawQueryParams.forEach((key, value) -> this.rawQueryParams.computeIfAbsent((String)key, it -> new ArrayList()).addAll(value));
            impl.decodedQueryParams.forEach((key, value) -> this.decodedQueryParams.computeIfAbsent((String)key, it -> new ArrayList()).addAll(value));
        } else {
            for (String name : uriQuery.names()) {
                List<String> raw = uriQuery.getAllRaw(name);
                this.rawQueryParams.computeIfAbsent(name, it -> new ArrayList()).addAll(raw);
                List decoded = uriQuery.all(name);
                this.decodedQueryParams.computeIfAbsent(name, it -> new ArrayList()).addAll(decoded);
            }
        }
        return this;
    }

    @Override
    public void clear() {
        this.rawQueryParams.clear();
        this.decodedQueryParams.clear();
    }

    @Override
    public String rawValue() {
        StringBuilder sb = new StringBuilder();
        for (Map.Entry<String, List<String>> entry : this.rawQueryParams.entrySet()) {
            String name = entry.getKey();
            for (String value : entry.getValue()) {
                sb.append('&');
                sb.append(name);
                sb.append('=');
                sb.append(value);
            }
        }
        if (sb.isEmpty()) {
            return "";
        }
        sb.deleteCharAt(0);
        return sb.toString();
    }

    @Override
    public String value() {
        if (this.decodedQueryParams.isEmpty()) {
            return "";
        }
        ArrayList params = new ArrayList(this.decodedQueryParams.size());
        this.decodedQueryParams.forEach((name, values) -> params.add(name + "=" + String.join((CharSequence)",", values)));
        return String.join((CharSequence)"&", params);
    }

    public OptionalValue<String> first(String name) {
        List<String> values = this.decodedQueryParams.get(name);
        if (values == null) {
            return OptionalValue.create((MapperManager)MapperManager.global(), (String)name, (GenericType)GenericType.STRING, (String[])new String[]{"uri", "query"});
        }
        String value = values.isEmpty() ? "" : values.iterator().next();
        return OptionalValue.create((MapperManager)MapperManager.global(), (String)name, (Object)value, (GenericType)GenericType.STRING, (String[])new String[]{"uri", "query"});
    }

    @Override
    public String getRaw(String name) throws NoSuchElementException {
        List<String> values = this.rawQueryParams.get(name);
        if (values == null) {
            throw new NoSuchElementException("Query parameter \"" + name + "\" is not available");
        }
        return values.isEmpty() ? "" : values.iterator().next();
    }

    @Override
    public List<String> getAllRaw(String name) throws NoSuchElementException {
        List<String> values = this.rawQueryParams.get(name);
        if (values == null) {
            throw new NoSuchElementException("Query parameter \"" + name + "\" is not available");
        }
        return values;
    }

    public List<String> all(String name) throws NoSuchElementException {
        List<String> values = this.decodedQueryParams.get(name);
        if (values == null) {
            throw new NoSuchElementException("Query parameter \"" + name + "\" is not available");
        }
        return values;
    }

    public List<Value<String>> allValues(String name) throws NoSuchElementException {
        List<String> values = this.decodedQueryParams.get(name);
        if (values == null) {
            throw new NoSuchElementException("Query parameter \"" + name + "\" is not available");
        }
        return values.stream().map(it -> Value.create((MapperManager)MapperManager.global(), (String)name, (Object)it, (GenericType)GenericType.STRING, (String[])new String[]{"uri", "query"})).collect(Collectors.toList());
    }

    public String get(String name) throws NoSuchElementException {
        List<String> values = this.decodedQueryParams.get(name);
        if (values == null) {
            throw new NoSuchElementException("Query parameter \"" + name + "\" is not available");
        }
        return values.isEmpty() ? "" : values.iterator().next();
    }

    public boolean contains(String name) {
        return this.rawQueryParams.containsKey(name);
    }

    public boolean isEmpty() {
        return this.decodedQueryParams.isEmpty();
    }

    public int size() {
        return this.decodedQueryParams.size();
    }

    public Set<String> names() {
        return this.decodedQueryParams.keySet();
    }

    public String component() {
        return "uri-query";
    }

    @Override
    public UriQueryWriteable set(String name, String ... values) {
        String encodedName = UriEncoding.encode(name, UriEncoding.Type.QUERY_PARAM_SPACE_ENCODED);
        ArrayList<String> decodedValues = new ArrayList<String>(values.length);
        ArrayList<String> encodedValues = new ArrayList<String>(values.length);
        for (String value : values) {
            decodedValues.add(value);
            encodedValues.add(UriEncoding.encode(value, UriEncoding.Type.QUERY_PARAM_SPACE_ENCODED));
        }
        this.rawQueryParams.put(encodedName, encodedValues);
        this.decodedQueryParams.put(name, decodedValues);
        return this;
    }

    @Override
    public UriQueryWriteable add(String name, String value) {
        String encodedName = UriEncoding.encodeUri(name);
        String encodedValue = UriEncoding.encodeUri(value);
        this.rawQueryParams.computeIfAbsent(encodedName, it -> new ArrayList(1)).add(encodedValue);
        this.decodedQueryParams.computeIfAbsent(name, it -> new ArrayList(1)).add(value);
        return this;
    }

    @Override
    public UriQueryWriteable setIfAbsent(String name, String ... value) {
        if (this.rawQueryParams.containsKey(name)) {
            return this;
        }
        return this.set(name, value);
    }

    @Override
    public UriQueryWriteable remove(String name) {
        this.rawQueryParams.remove(name);
        this.decodedQueryParams.remove(name);
        return this;
    }

    @Override
    public UriQueryWriteable remove(String name, Consumer<List<String>> removedConsumer) {
        this.rawQueryParams.remove(name);
        List<String> removed = this.decodedQueryParams.remove(name);
        if (removed != null) {
            removedConsumer.accept(removed);
        }
        return this;
    }

    @Override
    public void fromQueryString(String queryString) {
        String remaining = queryString;
        while (true) {
            int and;
            if ((and = remaining.indexOf(38)) == -1) break;
            String next = remaining.substring(0, and);
            remaining = remaining.substring(and + 1);
            this.addRaw(next);
        }
        this.addRaw(remaining);
    }

    public String toString() {
        return this.component() + ": decoded: " + String.valueOf(this.decodedQueryParams) + ", raw: " + String.valueOf(this.rawQueryParams);
    }

    private void addRaw(String next) {
        int eq = next.indexOf(61);
        if (eq == -1) {
            this.set(next, new String[0]);
        } else {
            String name = next.substring(0, eq);
            String value = next.substring(eq + 1);
            this.set(name, value);
        }
    }
}

