/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common;

import java.util.logging.Level;
import java.util.logging.LogRecord;
import java.util.logging.SimpleFormatter;
import java.util.logging.StreamHandler;
import java.util.regex.Pattern;

public class HelidonConsoleHandler
extends StreamHandler {
    public HelidonConsoleHandler() {
        this.setOutputStream(System.out);
        this.setLevel(Level.ALL);
        this.setFormatter(new ThreadFormatter());
    }

    @Override
    public void publish(LogRecord record) {
        super.publish(record);
        this.flush();
    }

    @Override
    public void close() {
        this.flush();
    }

    public static class ThreadFormatter
    extends SimpleFormatter {
        private static final Pattern THREAD_PATTERN = Pattern.compile("!thread!");

        @Override
        public String format(LogRecord record) {
            String message = super.format(record);
            return THREAD_PATTERN.matcher(message).replaceAll(Thread.currentThread().toString());
        }
    }
}

