/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common;

import java.util.Arrays;
import java.util.Optional;
import java.util.Set;
import java.util.function.Function;
import java.util.stream.Stream;

public final class StackWalker {
    private static final StackWalker INSTANCE = new StackWalker();

    public static StackWalker getInstance() {
        return INSTANCE;
    }

    public static StackWalker getInstance(Option option) {
        return INSTANCE;
    }

    public static StackWalker getInstance(Set<Option> options) {
        return INSTANCE;
    }

    public Class<?> getCallerClass() {
        Class<?>[] classContext = new MySecurityManager().getClassContext0();
        return classContext[3];
    }

    private StackWalker() {
    }

    public Optional<StackTraceElement> walk(Function<? super Stream<StackTraceElement>, Optional<StackTraceElement>> function) {
        StackTraceElement[] stackTrace = new Throwable().getStackTrace();
        return function.apply(Arrays.stream(stackTrace, 1, stackTrace.length));
    }

    static {
        SecurityManager sm = System.getSecurityManager();
        if (sm != null) {
            sm.checkPermission(new RuntimePermission("getStackWalker"));
        }
    }

    private static class MySecurityManager
    extends SecurityManager {
        private MySecurityManager() {
        }

        public Class<?>[] getClassContext0() {
            return super.getClassContext();
        }
    }

    public static enum Option {
        RETAIN_CLASS_REFERENCE;

    }
}

