/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common;

import io.helidon.common.LazyValue;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import java.util.function.Supplier;

class LazyValueImpl<T>
implements LazyValue<T> {
    private final Lock theLock = new ReentrantLock();
    private T value;
    private Supplier<T> delegate;
    private volatile boolean loaded;

    LazyValueImpl(T value) {
        this.value = value;
        this.loaded = true;
    }

    LazyValueImpl(Supplier<T> supplier) {
        this.delegate = supplier;
    }

    @Override
    public boolean isLoaded() {
        return this.loaded;
    }

    @Override
    public T get() {
        if (this.loaded) {
            return this.value;
        }
        this.theLock.lock();
        try {
            if (this.loaded) {
                T t = this.value;
                return t;
            }
            this.value = this.delegate.get();
            this.loaded = true;
            this.delegate = null;
        }
        finally {
            this.theLock.unlock();
        }
        return this.value;
    }
}

