/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common;

import io.helidon.common.Severity;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.logging.Logger;
import java.util.stream.Collectors;

public final class Errors
extends LinkedList<ErrorMessage> {
    private static final Set<StackWalker.Option> WALKER_OPTIONS = Set.of(StackWalker.Option.RETAIN_CLASS_REFERENCE);
    private final boolean hasFatal;
    private final boolean hasWarning;
    private final boolean hasHint;

    private Errors(Collector collector) {
        this.addAll(collector.errors);
        this.hasFatal = collector.hasFatal;
        this.hasWarning = collector.hasWarning;
        this.hasHint = collector.hasHint;
    }

    public static Collector collector() {
        return new Collector();
    }

    public boolean hasFatal() {
        return this.hasFatal;
    }

    public boolean hasWarning() {
        return this.hasWarning;
    }

    public boolean hasHint() {
        return this.hasHint;
    }

    public boolean log(Logger logger) {
        if (!this.isEmpty()) {
            StringBuilder fatals = new StringBuilder("\n");
            StringBuilder warnings = new StringBuilder();
            StringBuilder hints = new StringBuilder();
            block5: for (ErrorMessage error : this) {
                switch (error.getSeverity()) {
                    case FATAL: {
                        fatals.append(error).append('\n');
                        continue block5;
                    }
                    case WARN: {
                        warnings.append(error).append('\n');
                        continue block5;
                    }
                    case HINT: {
                        hints.append(error).append('\n');
                        continue block5;
                    }
                }
                hints.append(error).append('\n');
            }
            if (this.hasFatal) {
                fatals.append((CharSequence)warnings).append((CharSequence)hints);
                logger.severe("Fatal issues found: " + fatals);
            } else {
                if (warnings.length() > 0) {
                    logger.warning("Warnings found: \n" + warnings);
                }
                if (hints.length() > 0) {
                    logger.config("Hints found: \n" + hints);
                }
            }
            return !this.hasFatal;
        }
        return true;
    }

    @Override
    public String toString() {
        return this.stream().map(ErrorMessage::toString).collect(Collectors.joining("\n"));
    }

    public boolean isValid() {
        return !this.hasFatal;
    }

    public void checkValid() throws ErrorMessagesException {
        if (this.hasFatal) {
            throw new ErrorMessagesException(this);
        }
    }

    public static class ErrorMessage {
        private final Object source;
        private final String message;
        private final Severity severity;

        ErrorMessage(Object source, String message, Severity severity) {
            this.source = source;
            this.message = message;
            this.severity = severity;
        }

        public Severity getSeverity() {
            return this.severity;
        }

        public String getMessage() {
            return this.message;
        }

        public Object getSource() {
            return this.source;
        }

        public String toString() {
            return this.severity + ": " + this.message + " at " + this.source;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ErrorMessage that = (ErrorMessage)o;
            return Objects.equals(this.source, that.source) && Objects.equals(this.message, that.message) && this.severity == that.severity;
        }

        public int hashCode() {
            return Objects.hash(new Object[]{this.source, this.message, this.severity});
        }
    }

    public static final class ErrorMessagesException
    extends RuntimeException {
        private final List<ErrorMessage> messages;

        private ErrorMessagesException(List<ErrorMessage> messages) {
            super(messages.toString());
            this.messages = messages;
        }

        public List<ErrorMessage> getMessages() {
            return this.messages;
        }
    }

    public static class Collector {
        private final List<ErrorMessage> errors = new LinkedList<ErrorMessage>();
        private boolean hasFatal;
        private boolean hasWarning;
        private boolean hasHint;

        public Collector message(Object source, String message, Severity severity) {
            Objects.requireNonNull(message, "Message must be defined");
            Objects.requireNonNull(severity, "Severity must be defined");
            this.errors.add(new ErrorMessage(null == source ? "unknown" : source, message, severity));
            switch (severity) {
                case FATAL: {
                    this.hasFatal = true;
                    break;
                }
                case WARN: {
                    this.hasWarning = true;
                    break;
                }
                case HINT: {
                    this.hasHint = true;
                    break;
                }
            }
            return this;
        }

        public Collector message(String message, Severity severity) {
            return this.message(StackWalker.getInstance(WALKER_OPTIONS).getCallerClass(), message, severity);
        }

        public Collector fatal(String message) {
            return this.fatal(StackWalker.getInstance(WALKER_OPTIONS).getCallerClass(), message);
        }

        public Collector fatal(Object source, String message) {
            return this.message(source, message, Severity.FATAL);
        }

        public Collector warn(String message) {
            return this.warn(StackWalker.getInstance(WALKER_OPTIONS).getCallerClass(), message);
        }

        public Collector warn(Object source, String message) {
            return this.message(source, message, Severity.WARN);
        }

        public Collector hint(String message) {
            return this.hint(StackWalker.getInstance(WALKER_OPTIONS).getCallerClass(), message);
        }

        public Collector hint(Object source, String message) {
            return this.message(source, message, Severity.HINT);
        }

        public Errors collect() {
            Errors errors = new Errors(this);
            this.clear();
            return errors;
        }

        public Collector clear() {
            this.errors.clear();
            this.hasHint = false;
            this.hasFatal = false;
            this.hasWarning = false;
            return this;
        }

        public boolean hasFatal() {
            return this.hasFatal;
        }
    }
}

