/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common;

import io.helidon.common.FeatureDescriptor;
import io.helidon.common.HelidonFlavor;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.function.Supplier;

final class FeatureCatalog {
    private static final Map<String, Set<FeatureDescriptor>> FEATURES = new HashMap<String, Set<FeatureDescriptor>>();
    private static final Set<String> EXCLUDED = new HashSet<String>();

    static Set<FeatureDescriptor> get(String packageName) {
        Set<FeatureDescriptor> features = FEATURES.get(packageName);
        if (features == null) {
            if (packageName.startsWith("io.helidon.")) {
                if (EXCLUDED.contains(packageName)) {
                    return Set.of();
                }
                if (packageName.contains(".examples.") || packageName.contains(".tests.") || packageName.endsWith(".tests") || packageName.endsWith(".example")) {
                    return Set.of();
                }
            }
            return null;
        }
        return features;
    }

    private FeatureCatalog() {
    }

    private static void exclude(String packageName) {
        EXCLUDED.add(packageName);
    }

    private static void add(String packageName, String name, String description, String ... path) {
        FeatureCatalog.add(packageName, FeatureDescriptor.builder().name(name).path(path).description(description));
    }

    private static void addSe(String packageName, String name, String description, String ... path) {
        FeatureCatalog.add(packageName, FeatureDescriptor.builder().name(name).path(path).description(description).flavor(HelidonFlavor.SE));
    }

    private static void addMp(String packageName, String name, String description, String ... path) {
        FeatureCatalog.add(packageName, FeatureDescriptor.builder().name(name).path(path).description(description).flavor(HelidonFlavor.MP));
    }

    private static void add(String packageName, Supplier<FeatureDescriptor> descriptorBuilder) {
        FeatureDescriptor descriptor = descriptorBuilder.get();
        Set<FeatureDescriptor> featureDescriptors = FeatureCatalog.ensurePackage(packageName);
        if (!featureDescriptors.add(descriptor)) {
            throw new IllegalStateException("Feature " + descriptor.name() + " on path " + descriptor.stringPath() + " is registered more than once in package " + packageName);
        }
    }

    private static Set<FeatureDescriptor> ensurePackage(String packageName) {
        return FEATURES.computeIfAbsent(packageName, it -> new HashSet());
    }

    static {
        FeatureCatalog.addSe("io.helidon.config", "Config", "Configuration module", "Config");
        FeatureCatalog.add("io.helidon.grpc.server", FeatureDescriptor.builder().name("gRPC Server").description("Server for gRPC services").path("grpc").flavor(HelidonFlavor.SE).nativeSupported(true).nativeDescription("Experimental support in native image"));
        FeatureCatalog.add("io.helidon.grpc.client", FeatureDescriptor.builder().name("gRPC Client").description("Client for gRPC services").path("grpcClient").flavor(HelidonFlavor.SE).nativeSupported(true).nativeDescription("Experimental support in native image"));
        FeatureCatalog.addSe("io.helidon.grpc.metrics", "Metrics", "Metrics for gRPC services", "grpc", "Metrics");
        FeatureCatalog.addSe("io.helidon.grpc.metrics", "Metrics", "Metrics for gRPC client", "grpcClient", "Metrics");
        FeatureCatalog.addSe("io.helidon.health", "Health", "Health checks support", "Health");
        FeatureCatalog.addSe("io.helidon.media.jsonp", "JSON-P", "Media support for Jakarta JSON Processing", "WebServer", "Jsonp");
        FeatureCatalog.addSe("io.helidon.media.jsonp", "JSON-P", "Media support for Jakarta JSON Processing", "WebClient", "Jsonp");
        FeatureCatalog.addSe("io.helidon.media.jsonb", "JSON-B", "Media support for Jakarta JSON Binding", "WebServer", "Jsonb");
        FeatureCatalog.addSe("io.helidon.media.jsonb", "JSON-B", "Media support for Jakarta JSON Binding", "WebClient", "Jsonb");
        FeatureCatalog.addSe("io.helidon.media.jackson", "Jackson", "Media support for Jackson", "WebServer", "Jackson");
        FeatureCatalog.addSe("io.helidon.media.jackson", "Jackson", "Media support for Jackson", "WebClient", "Jackson");
        FeatureCatalog.addSe("io.helidon.media.multipart", "Multi-part", "Media support for Multi-part entities", "WebServer", "Multipart");
        FeatureCatalog.addSe("io.helidon.media.multipart", "Multi-part", "Media support for Multi-part entities", "WebClient", "Multipart");
        FeatureCatalog.add("io.helidon.messaging", FeatureDescriptor.builder().name("Messaging").description("Reactive messaging support").path("Messaging").flavor(HelidonFlavor.SE).experimental(true));
        FeatureCatalog.addSe("io.helidon.metrics", "Metrics", "Metrics support", "Metrics");
        FeatureCatalog.add("io.helidon.metrics.prometheus", FeatureDescriptor.builder().name("Prometheus").description("Metrics support for Prometheus").path("WebServer", "Prometheus").nativeSupported(false).flavor(HelidonFlavor.SE));
        FeatureCatalog.addSe("io.helidon.openapi", "OpenAPI", "Open API support", "OpenAPI");
        FeatureCatalog.addSe("io.helidon.security", "Security", "Security support", "Security");
        FeatureCatalog.addSe("io.helidon.tracing", "Tracing", "Tracing support", "Tracing");
        FeatureCatalog.addSe("io.helidon.webserver", "WebServer", "Helidon WebServer", "WebServer");
        FeatureCatalog.addSe("io.helidon.webserver.accesslog", "Access Log", "Access log support", "WebServer", "AccessLog");
        FeatureCatalog.addSe("io.helidon.webserver.cors", "CORS", "CORS support for WebServer", "WebServer", "CORS");
        FeatureCatalog.addSe("io.helidon.webserver.jersey", "Jersey", "WebServer integration with Jersey", "WebServer", "Jersey");
        FeatureCatalog.add("io.helidon.scheduling", FeatureDescriptor.builder().flavor(HelidonFlavor.SE).name("Scheduling").description("Scheduling of periodical tasks").path("Scheduling").nativeSupported(true));
        FeatureCatalog.add("io.helidon.webserver.tyrus", FeatureDescriptor.builder().flavor(HelidonFlavor.SE).name("Websocket").description("Jakarta Websocket implementation").path("WebServer", "Websocket").nativeSupported(true).nativeDescription("Server only"));
        FeatureCatalog.add("io.helidon.graphql.server", FeatureDescriptor.builder().name("GraphQL").description("GraphQL support").path("GraphQL").nativeDescription("Experimental support, tested on limited use cases").flavor(HelidonFlavor.SE).experimental(true));
        FeatureCatalog.add("io.helidon.integrations.micrometer", FeatureDescriptor.builder().name("Micrometer").description("Micrometer integration").path("Micrometer").experimental(true).nativeSupported(true).flavor(HelidonFlavor.SE));
        FeatureCatalog.add("io.helidon.integrations.oci.connect", FeatureDescriptor.builder().name("OCI").description("OCI Integration").path("OCI").flavor(HelidonFlavor.SE).experimental(true));
        FeatureCatalog.add("io.helidon.integrations.vault", FeatureDescriptor.builder().name("HCP Vault").description("Hashicorp Vault Integration").path("HCP Vault").flavor(HelidonFlavor.SE).experimental(true));
        FeatureCatalog.add("io.helidon.integrations.microstream", FeatureDescriptor.builder().name("Microstream").description("Microstream Integration").path("Microstream").flavor(HelidonFlavor.SE).experimental(true).nativeSupported(false));
        FeatureCatalog.add("io.helidon.integrations.cdi.eclipselink", FeatureDescriptor.builder().name("EclipseLink").description("EclipseLink support for Helidon MP").path("JPA", "EclipseLink").flavor(HelidonFlavor.MP).nativeSupported(false));
        FeatureCatalog.add("io.helidon.integrations.cdi.hibernate", FeatureDescriptor.builder().name("Hibernate").description("Hibernate support for Helidon MP").path("JPA", "Hibernate").flavor(HelidonFlavor.MP).nativeDescription("Experimental support, tested on limited use cases"));
        FeatureCatalog.add("io.helidon.integrations.cdi.jpa", FeatureDescriptor.builder().name("JPA").description("Jakarta persistence API support for Helidon MP").flavor(HelidonFlavor.MP).path("JPA"));
        FeatureCatalog.add("io.helidon.integrations.jta.cdi", FeatureDescriptor.builder().name("JTA").description("Jakarta transaction API support for Helidon MP").path("JTA").flavor(HelidonFlavor.MP).nativeDescription("Experimental support, tested on limited use cases"));
        FeatureCatalog.addMp("io.helidon.microprofile.accesslog", "Access Log", "Access log support", "Server", "AccessLog");
        FeatureCatalog.addMp("io.helidon.microprofile.cdi", "CDI", "Jakarta CDI implementation", "CDI");
        FeatureCatalog.addMp("io.helidon.microprofile.config", "Config", "MicroProfile configuration spec implementation", "Config");
        FeatureCatalog.addMp("io.helidon.microprofile.cors", "CORS", "CORS support for Server", "Server", "CORS");
        FeatureCatalog.addMp("io.helidon.microprofile.faulttolerance", "Fault Tolerance", "MicroProfile Fault Tolerance spec implementation", "FT");
        FeatureCatalog.add("io.helidon.microprofile.graphql.server", FeatureDescriptor.builder().name("GraphQL").description("MicroProfile GraphQL spec implementation").path("GraphQL").nativeDescription("Experimental support, tested on limited use cases").flavor(HelidonFlavor.MP).experimental(true));
        FeatureCatalog.add("io.helidon.microprofile.grpc.server", FeatureDescriptor.builder().name("gRPC Server").description("Server for gRPC services").path("grpc").flavor(HelidonFlavor.MP).nativeSupported(false));
        FeatureCatalog.add("io.helidon.microprofile.grpc.client", FeatureDescriptor.builder().name("gRPC Client").description("Client for gRPC services").path("grpcClient").flavor(HelidonFlavor.MP).nativeSupported(false));
        FeatureCatalog.addMp("io.helidon.microprofile.grpc.metrics", "Metrics", "Metrics for gRPC client", "grpcClient", "Metrics");
        FeatureCatalog.addMp("io.helidon.microprofile.grpc.metrics", "Metrics", "Metrics for gRPC server", "grpcServer", "Metrics");
        FeatureCatalog.addMp("io.helidon.microprofile.health", "Health", "MicroProfile Health spec implementation", "Health");
        FeatureCatalog.addMp("io.helidon.microprofile.jwt.auth", "JWT Auth", "MicroProfile JWT Auth spec implementation", "Security", "JWTAuth");
        FeatureCatalog.add("io.helidon.microprofile.messaging", FeatureDescriptor.builder().name("Messaging").description("MicroProfile Reactive Messaging spec implementation").path("Messaging").flavor(HelidonFlavor.MP).experimental(true));
        FeatureCatalog.addMp("io.helidon.microprofile.metrics", "Metrics", "MicroProfile metrics spec implementation", "Metrics");
        FeatureCatalog.addMp("io.helidon.microprofile.openapi", "Open API", "MicroProfile Open API spec implementation", "OpenAPI");
        FeatureCatalog.add("io.helidon.microprofile.reactive", FeatureDescriptor.builder().name("Reactive").description("MicroProfile Reactive Stream operators").path("Reactive").flavor(HelidonFlavor.MP).experimental(true));
        FeatureCatalog.addMp("io.helidon.microprofile.security", "Security", "Security support", "Security");
        FeatureCatalog.addMp("io.helidon.microprofile.server", "Server", "Server for Helidon MP", "Server");
        FeatureCatalog.addMp("io.helidon.microprofile.server", "JAX-RS", "Jakarta JAX-RS implementation (Jersey)", "JAX-RS");
        FeatureCatalog.addMp("io.helidon.microprofile.tracing", "Tracing", "MicroProfile tracing spec implementation", "Tracing");
        FeatureCatalog.add("io.helidon.microprofile.tyrus", FeatureDescriptor.builder().flavor(HelidonFlavor.MP).name("Websocket").description("Jakarta Websocket implementation").path("Websocket").nativeSupported(false));
        FeatureCatalog.add("io.helidon.microprofile.restclient", FeatureDescriptor.builder().name("REST Client").description("MicroProfile REST client spec implementation").path("RESTClient").flavor(HelidonFlavor.MP).nativeDescription("Does not support execution of default methods on interfaces."));
        FeatureCatalog.add("io.helidon.integrations.micronaut.cdi", FeatureDescriptor.builder().name("Micronaut").description("Micronaut integration").path("CDI", "Micronaut").flavor(HelidonFlavor.MP).experimental(true));
        FeatureCatalog.add("io.helidon.integrations.micronaut.cdi.data", FeatureDescriptor.builder().name("Micronaut Data").description("Micronaut Data integration").path("CDI", "Micronaut", "Data").flavor(HelidonFlavor.MP).experimental(true));
        FeatureCatalog.add("io.helidon.microprofile.scheduling", FeatureDescriptor.builder().name("Scheduling").description("Task scheduling").path("Scheduling").flavor(HelidonFlavor.MP).nativeSupported(true).experimental(true));
        FeatureCatalog.add("io.helidon.integrations.micrometer.cdi", FeatureDescriptor.builder().name("Micrometer").description("Micrometer integration").path("Micrometer").experimental(true).nativeSupported(true).flavor(HelidonFlavor.MP));
        FeatureCatalog.add("io.helidon.integrations.oci.cdi", FeatureDescriptor.builder().name("OCI").description("OCI Integration").path("OCI").flavor(HelidonFlavor.MP).experimental(true));
        FeatureCatalog.add("io.helidon.integrations.vault.cdi", FeatureDescriptor.builder().name("HCP Vault").description("Hashicorp Vault Integration").path("HCP Vault").flavor(HelidonFlavor.MP).experimental(true));
        FeatureCatalog.add("io.helidon.microprofile.lra", FeatureDescriptor.builder().name("Long Running Actions").description("MicroProfile Long Running Actions").path("LRA").flavor(HelidonFlavor.MP).nativeSupported(true).experimental(true));
        FeatureCatalog.add("io.helidon.integrations.microstream.cdi", FeatureDescriptor.builder().name("Microstream").description("Microstream Integration").path("Microstream").flavor(HelidonFlavor.MP).experimental(true).nativeSupported(false));
        FeatureCatalog.add("io.helidon.config.encryption", "Encryption", "Support for secret encryption in config", "Config", "Encryption");
        FeatureCatalog.add("io.helidon.config.etcd", FeatureDescriptor.builder().name("etcd").description("Config source based on etcd").path("Config", "etcd").nativeSupported(false));
        FeatureCatalog.add("io.helidon.config.git", "git", "Config source based on a git repository", "Config", "git");
        FeatureCatalog.add("io.helidon.config.hocon", "HOCON", "HOCON media type support for config", "Config", "HOCON");
        FeatureCatalog.add("io.helidon.config.objectmapping", "Object Mapping", "Object mapping support for Config", "Config", "ObjectMapping");
        FeatureCatalog.add("io.helidon.config.yaml", "YAML", "YAML media type support for config", "Config", "YAML");
        FeatureCatalog.add("io.helidon.dbclient", FeatureDescriptor.builder().name("Db Client").description("Reactive database client").path("DbClient").experimental(true));
        FeatureCatalog.add("io.helidon.dbclient.health", "Health Check", "Reactive database client health check support", "DbClient", "Health");
        FeatureCatalog.add("io.helidon.dbclient.jsonp", "JSON-P", "JSON Processing mapping DbRow", "DbClient", "JSON-P");
        FeatureCatalog.add("io.helidon.dbclient.jdbc", FeatureDescriptor.builder().name("JDBC").description("Reactive database client over JDBC").path("DbClient", "JDBC").nativeDescription("Tested with Helidon Oracle and H2 drivers (see examples)"));
        FeatureCatalog.add("io.helidon.dbclient.metrics", "Metrics", "Reactive database client metrics support", "DbClient", "Metrics");
        FeatureCatalog.add("io.helidon.dbclient.mongodb", "mongo", "Reactive database client with reactive mongo driver", "DbClient", "mongo");
        FeatureCatalog.add("io.helidon.dbclient.tracing", "Tracing", "Reactive database client tracing support", "DbClient", "Tracing");
        FeatureCatalog.add("io.helidon.health.checks", "Built-ins", "Built in health checks", "Health", "Builtins");
        FeatureCatalog.add("io.helidon.messaging.connectors.kafka", FeatureDescriptor.builder().name("Kafka Connector").description("Reactive messaging connector for Kafka").path("Messaging", "Kafka").experimental(true).nativeSupported(true));
        FeatureCatalog.add("io.helidon.messaging.connectors.jms", FeatureDescriptor.builder().name("JMS Connector").description("Reactive messaging connector for JMS").path("Messaging", "JMS").experimental(true).nativeSupported(false));
        FeatureCatalog.add("io.helidon.messaging.connectors.aq", FeatureDescriptor.builder().name("Oracle AQ Connector").description("Reactive messaging connector for Oracle AQ").path("Messaging", "OracleAQ").experimental(true).nativeSupported(false));
        FeatureCatalog.add("io.helidon.security.abac.policy.el", FeatureDescriptor.builder().name("EL").description("ABAC Jakarta Expression Language policy support").path("Security", "Provider", "ABAC", "Policy", "EL").nativeSupported(true).nativeDescription("Properties used in expressions must have reflection configuration added"));
        FeatureCatalog.add("io.helidon.security.abac.role", "Role", "ABAC Role based attribute validator", "Security", "Provider", "ABAC", "Role");
        FeatureCatalog.add("io.helidon.security.abac.scope", "Scope", "ABAC Scope based attribute validator", "Security", "Provider", "ABAC", "Scope");
        FeatureCatalog.add("io.helidon.security.abac.time", "Time", "ABAC Time based attribute validator", "Security", "Provider", "ABAC", "Time");
        FeatureCatalog.add("io.helidon.security.integration.grpc", "gRPC", "Security integration with gRPC", "Security", "Integration", "gRPC");
        FeatureCatalog.add("io.helidon.security.integration.jersey", "Jersey", "Security integration with Jersey (JAX-RS implementation)", "Security", "Integration", "Jersey");
        FeatureCatalog.add("io.helidon.security.integration.webserver", "WebServer", "Security integration with web server", "Security", "Integration", "WebServer");
        FeatureCatalog.add("io.helidon.security.providers.abac", "ABAC", "Security provider for attribute based access control", "Security", "Provider", "ABAC");
        FeatureCatalog.add("io.helidon.security.providers.google.login", FeatureDescriptor.builder().name("Google Login").description("Security provider for Google login button authentication and outbound").path("Security", "Provider", "Google-Login").nativeSupported(false));
        FeatureCatalog.add("io.helidon.security.providers.header", "Header", "Security provider for header based authentication", "Security", "Provider", "Header");
        FeatureCatalog.add("io.helidon.security.providers.httpauth", "HTTP Basic", "Security provider for HTTP Basic authentication and outbound", "Security", "Provider", "HttpBasic");
        FeatureCatalog.add("io.helidon.security.providers.httpauth", "HTTP Digest", "Security provider for HTTP Digest authentication", "Security", "Provider", "HttpDigest");
        FeatureCatalog.add("io.helidon.security.providers.httpsign", "HTTP Signatures", "Security provider for HTTP Signature authentication and outbound", "Security", "Provider", "HttpSign");
        FeatureCatalog.add("io.helidon.security.providers.config.vault", "Config Vault", "Security", "Provider", "ConfigVault");
        FeatureCatalog.add("io.helidon.security.providers.idcs.mapper", FeatureDescriptor.builder().name("IDCS Role Mapper").description("Security provider role mapping - Oracle IDCS").path("Security", "Provider", "IdcsRoleMapper").nativeSupported(false));
        FeatureCatalog.add("io.helidon.security.providers.jwt", "JWT", "Security provider for JWT based authentication", "Security", "Provider", "JWT");
        FeatureCatalog.add("io.helidon.security.providers.oidc", "OIDC", "Security provider for Open ID Connect authentication", "Security", "OIDC");
        FeatureCatalog.add("io.helidon.tracing.jaeger", "Jaeger", "Jaeger tracer integration", "Tracing", "Jaeger");
        FeatureCatalog.add("io.helidon.metrics.jaeger", "Jaeger metrics", "Jaeger tracer metrics integration", "Metrics", "Jaeger");
        FeatureCatalog.add("io.helidon.tracing.jersey", "Jersey Server", "Tracing integration with Jersey server", "Tracing", "Integration", "Jersey");
        FeatureCatalog.add("io.helidon.tracing.jersey.client", "Jersey Client", "Tracing integration with Jersey client", "Tracing", "Integration", "JerseyClient");
        FeatureCatalog.add("io.helidon.tracing.zipkin", "Zipkin", "Zipkin tracer integration", "Tracing", "Zipkin");
        FeatureCatalog.add("io.helidon.integrations.neo4j", FeatureDescriptor.builder().name("Neo4j integration").description("Integration with Neo4j driver").path("Neo4j").experimental(true).nativeSupported(true));
        FeatureCatalog.add("io.helidon.integrations.neo4j.health", FeatureDescriptor.builder().name("Neo4j Health").description("Health check for Neo4j integration").path("Neo4j", "Health"));
        FeatureCatalog.add("io.helidon.integrations.neo4j.metrics", FeatureDescriptor.builder().name("Neo4j Metrics").description("Metrics for Neo4j integration").path("Neo4j", "Metrics"));
        FeatureCatalog.add("io.helidon.webclient", FeatureDescriptor.builder().name("Web Client").description("Reactive web client").path("WebClient").experimental(true));
        FeatureCatalog.add("io.helidon.webclient.metrics", "Metrics", "Reactive web client support for metrics", "WebClient", "Metrics");
        FeatureCatalog.add("io.helidon.webclient.security", "Security", "Reactive web client support for security", "WebClient", "Security");
        FeatureCatalog.add("io.helidon.webclient.tracing", "Tracing", "Reactive web client support for tracing", "WebClient", "Tracing");
        FeatureCatalog.add("io.helidon.logging.log4j", FeatureDescriptor.builder().name("Log4j").path("Logging", "Log4j").description("Log4j MDC support").nativeDescription("Only programmatic configuration supported, does not work with Helidon loggers"));
        FeatureCatalog.add("io.helidon.webserver.staticcontent", "Static Content", "Static content support for webserver", "WebServer", "Static Content");
        FeatureCatalog.add("io.helidon.integrations.oci.objectstorage", "OCI Object Storage", "Integration with OCI Object Storage", "OCI", "Object Storage");
        FeatureCatalog.add("io.helidon.integrations.oci.vault", "OCI Vault", "Integration with OCI Vault", "OCI", "Vault");
        FeatureCatalog.add("io.helidon.integrations.oci.telemetry", "OCI Telemetry", "Integration with OCI Telemetry", "OCI", "Telemetry");
        FeatureCatalog.add("io.helidon.integrations.vault.auths.approle", "AppRole", "AppRole Authentication Method", "HCP Vault", "Auth", "AppRole");
        FeatureCatalog.add("io.helidon.integrations.vault.auths.k8s", "k8s", "Kubernetes Authentication Method", "HCP Vault", "Auth", "k8s");
        FeatureCatalog.add("io.helidon.integrations.vault.auths.token", "Token", "Token Authentication Method", "HCP Vault", "Auth", "Token");
        FeatureCatalog.add("io.helidon.integrations.vault.secrets.cubbyhole", "Cubbyhole", "Cubbyhole Secrets Engine", "HCP Vault", "Secrets", "Cubbyhole");
        FeatureCatalog.add("io.helidon.integrations.vault.secrets.database", "Database", "Database Secrets Engine", "HCP Vault", "Secrets", "Database");
        FeatureCatalog.add("io.helidon.integrations.vault.secrets.kv1", "K/V 1", "Key/Value Version 1 Secrets Engine", "HCP Vault", "Secrets", "K/V 1");
        FeatureCatalog.add("io.helidon.integrations.vault.secrets.kv2", "K/V 2", "Key/Value Version 2 Secrets Engine", "HCP Vault", "Secrets", "K/V 2");
        FeatureCatalog.add("io.helidon.integrations.vault.secrets.pki", "PKI", "PKI Secrets Engine", "HCP Vault", "Secrets", "PKI");
        FeatureCatalog.add("io.helidon.integrations.vault.secrets.transit", "Transit", "Transit Secrets Engine", "HCP Vault", "Secrets", "Transit");
        FeatureCatalog.add("io.helidon.integrations.vault.sys", "Sys", "System operations", "HCP Vault", "Sys");
        FeatureCatalog.exclude("io.helidon.bundles.config");
        FeatureCatalog.exclude("io.helidon.common");
        FeatureCatalog.exclude("io.helidon.common.configurable");
        FeatureCatalog.exclude("io.helidon.common.context");
        FeatureCatalog.exclude("io.helidon.common.features");
        FeatureCatalog.exclude("io.helidon.common.http");
        FeatureCatalog.exclude("io.helidon.common.mapper");
        FeatureCatalog.exclude("io.helidon.common.mapper.spi");
        FeatureCatalog.exclude("io.helidon.common.media.type");
        FeatureCatalog.exclude("io.helidon.common.media.type.spi");
        FeatureCatalog.exclude("io.helidon.common.pki");
        FeatureCatalog.exclude("io.helidon.common.reactive");
        FeatureCatalog.exclude("io.helidon.common.serviceloader");
        FeatureCatalog.exclude("io.helidon.config.spi");
        FeatureCatalog.exclude("io.helidon.config.mp");
        FeatureCatalog.exclude("io.helidon.config.mp.spi");
        FeatureCatalog.exclude("io.helidon.dbclient.common");
        FeatureCatalog.exclude("io.helidon.dbclient.jdbc.spi");
        FeatureCatalog.exclude("io.helidon.dbclient.metrics.jdbc");
        FeatureCatalog.exclude("io.helidon.dbclient.spi");
        FeatureCatalog.exclude("io.helidon.health.common");
        FeatureCatalog.exclude("io.helidon.integrations.cdi.delegates");
        FeatureCatalog.exclude("io.helidon.integrations.cdi.referencecountedcontext");
        FeatureCatalog.exclude("io.helidon.integrations.cdi.jpa.jaxb");
        FeatureCatalog.exclude("io.helidon.integrations.datasource.cdi");
        FeatureCatalog.exclude("io.helidon.integrations.datasource.hikaricp.cdi");
        FeatureCatalog.exclude("io.helidon.integrations.db.h2");
        FeatureCatalog.exclude("io.helidon.integrations.graal.nativeimage.extension");
        FeatureCatalog.exclude("io.helidon.integrations.graal.mp.nativeimage.extension");
        FeatureCatalog.exclude("io.helidon.integrations.jta.weld");
        FeatureCatalog.exclude("io.helidon.jersey.common");
        FeatureCatalog.exclude("io.helidon.logging.common");
        FeatureCatalog.exclude("io.helidon.logging.jul");
        FeatureCatalog.exclude("io.helidon.media.common");
        FeatureCatalog.exclude("io.helidon.media.common.spi");
        FeatureCatalog.exclude("io.helidon.openapi.internal");
        FeatureCatalog.exclude("io.helidon.security.abac.policy");
        FeatureCatalog.exclude("io.helidon.security.abac.policy.spi");
        FeatureCatalog.exclude("io.helidon.security.annotations");
        FeatureCatalog.exclude("io.helidon.security.integration.common");
        FeatureCatalog.exclude("io.helidon.security.integration.jersey.client");
        FeatureCatalog.exclude("io.helidon.security.internal");
        FeatureCatalog.exclude("io.helidon.security.jwt");
        FeatureCatalog.exclude("io.helidon.security.jwt.jwk");
        FeatureCatalog.exclude("io.helidon.security.providers.abac.spi");
        FeatureCatalog.exclude("io.helidon.security.providers.common");
        FeatureCatalog.exclude("io.helidon.security.providers.common.spi");
        FeatureCatalog.exclude("io.helidon.security.providers.httpauth.spi");
        FeatureCatalog.exclude("io.helidon.security.providers.oidc.common");
        FeatureCatalog.exclude("io.helidon.security.spi");
        FeatureCatalog.exclude("io.helidon.security.util");
        FeatureCatalog.exclude("io.helidon.tracing.config");
        FeatureCatalog.exclude("io.helidon.tracing.jersey.client.internal");
        FeatureCatalog.exclude("io.helidon.tracing.spi");
        FeatureCatalog.exclude("io.helidon.tracing.tracerresolver");
        FeatureCatalog.exclude("io.helidon.webclient.jaxrs");
        FeatureCatalog.exclude("io.helidon.webclient.spi");
        FeatureCatalog.exclude("io.helidon.common.context.spi");
        FeatureCatalog.exclude("io.helidon.grpc.core");
    }
}

