/*
 * Decompiled with CFR 0.152.
 */
package io.helidon.common;

import io.helidon.common.LazyValue;
import java.nio.charset.StandardCharsets;
import java.util.Base64;

public class Base64Value {
    private static final Base64.Encoder ENCODER = Base64.getEncoder();
    private static final Base64.Decoder DECODER = Base64.getDecoder();
    private final LazyValue<String> base64;
    private final LazyValue<byte[]> bytes;
    private final LazyValue<String> plainString;

    private Base64Value(String base64) {
        this.base64 = LazyValue.create(base64);
        this.bytes = LazyValue.create(() -> DECODER.decode(base64));
        this.plainString = LazyValue.create(() -> new String((byte[])this.bytes.get(), StandardCharsets.UTF_8));
    }

    private Base64Value(byte[] bytes) {
        this.bytes = LazyValue.create(bytes);
        this.base64 = LazyValue.create(() -> ENCODER.encodeToString(bytes));
        this.plainString = LazyValue.create(() -> new String(bytes, StandardCharsets.UTF_8));
    }

    private Base64Value(String plainString, boolean ignored) {
        this.plainString = LazyValue.create(plainString);
        this.bytes = LazyValue.create(() -> plainString.getBytes(StandardCharsets.UTF_8));
        this.base64 = LazyValue.create(() -> ENCODER.encodeToString((byte[])this.bytes.get()));
    }

    public static Base64Value create(String plainText) {
        return new Base64Value(plainText, true);
    }

    public static Base64Value create(byte[] bytes) {
        return new Base64Value(bytes);
    }

    public static Base64Value createFromEncoded(String base64Text) {
        return new Base64Value(base64Text);
    }

    public String toBase64() {
        return (String)this.base64.get();
    }

    public byte[] toBytes() {
        return (byte[])this.bytes.get();
    }

    public String toDecodedString() {
        return (String)this.plainString.get();
    }

    public String toString() {
        return (String)this.base64.get();
    }
}

