/*
 * Copyright (c) 2019, 2023 Oracle and/or its affiliates.
 *
 * Licensed under the Apache License, Version 2.0 (the "License");
 * you may not use this file except in compliance with the License.
 * You may obtain a copy of the License at
 *
 *     http://www.apache.org/licenses/LICENSE-2.0
 *
 * Unless required by applicable law or agreed to in writing, software
 * distributed under the License is distributed on an "AS IS" BASIS,
 * WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
 * See the License for the specific language governing permissions and
 * limitations under the License.
 */

package io.helidon.common;

/**
 * Simple class to provide version information.
 */
public final class Version {

    private Version() {
        // cannot be instanciated
    }

    /**
     * Version.
     */
    public static final String VERSION = "4.0.10";

    /**
     * Revision Number.
     */
    public static final String REVISION = "e763230b9fe24d26f2761eee955168d3cab33a2e";

    /**
     * Display version
     *
     * @param args Ignored
     */
    public static void main(String[] args) {
        System.out.println(VERSION + " " + REVISION);
    }
}
